/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.audit.v2.core;

import de.intarsys.security.audit.v2.core.Audit;
import de.intarsys.security.audit.v2.core.AuditException;
import de.intarsys.security.audit.v2.core.AuditSession;
import de.intarsys.security.audit.v2.core.IAuditEntry;
import de.intarsys.security.audit.v2.core.IAuditSessionKeyCodec;
import de.intarsys.tools.json.JsonObject;
import de.intarsys.tools.json.JsonReader;
import java.util.Arrays;
import java.util.Map;

public class AuditValidator {
    private AuditSession session;
    private final Audit audit;
    private String digestAlgorithm = "SHA256";
    private String hmacAlgorithm = "HmacSHA1";
    private byte[] sessionKey;

    public AuditValidator(Audit audit) {
        this.audit = audit;
    }

    public void accept(IAuditEntry entry) throws AuditException {
        byte[] seal;
        if ('O' == entry.getAuditCommand()) {
            this.acceptOpen(entry);
        }
        if ('S' == entry.getAuditCommand()) {
            this.acceptSign(entry);
        }
        if (!Arrays.equals(seal = this.getAudit().getProtocol().acceptEntry(this.getSession(), entry), entry.getAuditSeal())) {
            throw new AuditException("validation failed");
        }
    }

    protected void acceptOpen(IAuditEntry entry) throws AuditException {
        try {
            String message = entry.getAuditMessage();
            JsonReader reader = new JsonReader(message);
            JsonObject jsonInit = reader.readJsonObject();
            String version = jsonInit.getString("v");
            if (!"2.0".equals(version)) {
                throw new AuditException("version mismatch");
            }
            String hash = jsonInit.getString("hash");
            String mac = jsonInit.getString("mac");
            this.setDigestAlgorithm(hash);
            this.setHmacAlgorithm(mac);
            Map keyParams = jsonInit.getJSONObject("key").toJava();
            this.createSessionKey(keyParams);
            this.open();
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
    }

    protected void acceptSign(IAuditEntry entry) throws AuditException {
        try {
            String message = entry.getAuditMessage();
            JsonReader reader = new JsonReader(message);
            JsonObject jsonInit = reader.readJsonObject();
            Map signatureParams = jsonInit.toJava();
            this.getAudit().getSignatureProvider().validate(signatureParams, this.getSession().getPreviousDigest());
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
    }

    public void createSessionKey(Map keyParams) throws AuditException {
        IAuditSessionKeyCodec codec = this.getAudit().getSessionKeyCodec();
        this.setSessionKey(codec.createSessionKey(keyParams));
    }

    public Audit getAudit() {
        return this.audit;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String getHmacAlgorithm() {
        return this.hmacAlgorithm;
    }

    public AuditSession getSession() {
        return this.session;
    }

    protected byte[] getSessionKey() {
        return this.sessionKey;
    }

    public void open() throws AuditException {
        this.session = (AuditSession)this.getAudit().createSession(this.getSessionKey(), null, 0);
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setHmacAlgorithm(String hmacAlgorithm) {
        this.hmacAlgorithm = hmacAlgorithm;
    }

    public void setSession(AuditSession session) {
        this.session = session;
    }

    protected void setSessionKey(byte[] sessionKey) {
        this.sessionKey = sessionKey;
    }
}

