/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.activity.RequestConfirmation;
import de.intarsys.tools.license.EnumLicenseState;
import de.intarsys.tools.license.License;
import de.intarsys.tools.license.LicenseAccount;
import de.intarsys.tools.license.LicenseContainerSerializer;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicenseProperty;
import de.intarsys.tools.license.LicenseRepository;
import de.intarsys.tools.license.LicensesHandler;
import de.intarsys.tools.license.PACKAGE;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.observation.api.Observation;
import de.intarsys.tools.sax.SAXTools;
import de.intarsys.tools.serialize.SerializationContext;
import de.intarsys.tools.serialize.xml.XMLSerializationContext;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.crypto.Cipher;
import javax.xml.parsers.SAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class LicenseTools {
    private static IMessageBundle Msg = PACKAGE.Messages;
    private static SAXParser parser;
    private static final Set accessOK;
    private static final Logger Log;

    public static LicenseProduct createProduct(Object context, String id) {
        return LicenseTools.createProduct(context, id, false);
    }

    public static LicenseProduct createProduct(Object context, String id, boolean free) {
        String version = LicenseEnvironment.get().getLicenseProduct().getVersion();
        return LicenseTools.createProduct(context, id, version, free);
    }

    public static LicenseProduct createProduct(Object context, String id, String version, boolean free) {
        LicenseProduct product = new LicenseProduct();
        product.setId(id);
        product.setVersion(version);
        product.setFree(free);
        product.setContext(context);
        return LicenseEnvironment.get().registerProduct(product);
    }

    public static byte[] decrypt(byte[] chiffre, Key key) throws LicenseException {
        if (chiffre == null || key == null) {
            return null;
        }
        try {
            Cipher cipher;
            try {
                cipher = Cipher.getInstance("RSA/NONE/PKCS1PADDING");
            }
            catch (NoSuchAlgorithmException e) {
                cipher = Cipher.getInstance("RSA");
            }
            cipher.init(2, key);
            return cipher.doFinal(chiffre);
        }
        catch (Exception e) {
            throw new LicenseException(e.getMessage(), e);
        }
    }

    public static byte[] encrypt(byte[] text, Key key) throws LicenseException {
        if (text == null || key == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance("RSA/NONE/PKCS1Padding");
            cipher.init(1, key);
            return cipher.doFinal(text);
        }
        catch (Exception e) {
            throw new LicenseException(e.getMessage(), e);
        }
    }

    public static List<LicenseProperty> getLicenseProperties(List<License> licenses, String propertyName) {
        ArrayList<LicenseProperty> properties = new ArrayList<LicenseProperty>();
        for (License license : licenses) {
            Iterator<LicenseProperty> it = license.getProperties(propertyName);
            while (it.hasNext()) {
                properties.add(it.next());
            }
        }
        return properties;
    }

    public static LicenseProperty getLicensePropertyMax(List<License> licenses, String propertyName) {
        LicenseProperty property = null;
        for (License license : licenses) {
            Iterator<LicenseProperty> it = license.getProperties(propertyName);
            while (it.hasNext()) {
                float propertyValue;
                LicenseProperty tempProperty = it.next();
                if (tempProperty.isUnlimited()) {
                    return tempProperty;
                }
                if (property == null) {
                    property = tempProperty;
                    continue;
                }
                float tempValue = tempProperty.getCanonicalValue();
                if (!(tempValue > (propertyValue = property.getCanonicalValue()))) continue;
                property = tempProperty;
            }
        }
        return property;
    }

    public static EnumLicenseState getLicensePropertyWithValueState(List<License> licenses, String property, String value) {
        EnumLicenseState result = EnumLicenseState.NA;
        for (License license : licenses) {
            Iterator<LicenseProperty> it = license.getProperties(property);
            while (it.hasNext()) {
                LicenseProduct product;
                EnumLicenseState tempState;
                LicenseProperty tempProperty = it.next();
                String tempValue = tempProperty.getValue();
                if (tempValue == null || !tempValue.equals(value) || result.compareTo((Object)(tempState = license.getState(product = LicenseEnvironment.get().lookupProduct(license.getProductId())))) >= 0) continue;
                result = tempState;
            }
        }
        return result;
    }

    public static synchronized List<License> loadLicense(ILocator locator) throws LicenseException {
        InputStream is = null;
        try {
            is = locator.getInputStream();
            if (is == null) {
                Log.info("license stream '{}' not found", (Object)locator.getPath());
                List<License> list = Collections.emptyList();
                return list;
            }
            LicensesHandler handler = new LicensesHandler();
            parser.parse(is, (DefaultHandler)((Object)handler));
            for (License license : handler.getLicenses()) {
                license.setLocator(locator);
            }
            List<License> list = handler.getLicenses();
            return list;
        }
        catch (SAXException e) {
            if (e.getException() instanceof LicenseException) {
                throw (LicenseException)e.getException();
            }
            throw new LicenseException("error parsing '" + locator.getPath() + "'", e);
        }
        catch (FileNotFoundException e) {
            Log.info("license stream '{}' not found", (Object)locator.getPath());
            List<License> list = Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            if (e.getCause() instanceof LicenseException) {
                throw (LicenseException)e.getCause();
            }
            throw new LicenseException("error parsing '" + locator.getPath() + "'", e);
        }
        finally {
            StreamTools.close((Closeable)is);
        }
    }

    public static boolean matchesPattern(License license, String property, String value) {
        if (StringTools.isEmpty((String)property)) {
            return true;
        }
        List<String> patterns = license.getPropertyValues(property);
        for (String pattern : patterns) {
            pattern = pattern.trim();
            try {
                if (!value.matches(pattern)) continue;
                return true;
            }
            catch (PatternSyntaxException e) {
                Log.info("license {} property {} is not a pattern", (Object)license, (Object)pattern);
            }
        }
        return false;
    }

    public static void publishLoaded(License license) {
        String productId = license.getProductId();
        LicenseProduct product = LicenseEnvironment.get().lookupProduct(productId);
        Observation.builder().source("license").message(Msg.getMessage("loaded", new Object[0])).put("locator", (Object)license.getLocator().getPath()).put("product", (Object)productId).put("validFrom", (Object)license.getValidFromString()).put("validTo", (Object)license.getValidToString()).put("state", (Object)license.getState(product).toString()).put("properties", (Object)license.getPropertiesString()).build().publish();
    }

    public static void publishWithdraw(LicenseAccount account, LicenseProperty property, int amount) {
        Observation.builder().source("license").message(Msg.getMessage("withdraw", new Object[0])).put("amount", (Object)amount).put("product", (Object)account.getLicenseProduct().getId()).put("property", (Object)account.getPropertyName()).put("limit", (Object)account.getLimit(property)).put("balance", (Object)account.getBalance(property)).put("nextReset", (Object)account.getNextReset(property).toEpochMilli()).build().publish();
    }

    public static boolean requestWatermarkConsent(Object context) {
        IMessage msg;
        if (accessOK.contains(context)) {
            return true;
        }
        IMessage title = Msg.getMessage("LicenseTools.licenseRestriction.title", new Object[0]);
        IMessage choice = RequestConfirmation.requestYesNo(null, (IMessage)title, (IMessage)(msg = Msg.getMessage("LicenseTools.licenseRestriction.message", new Object[0])), (IMessage)RequestConfirmation.OPTION_NO);
        if (choice == RequestConfirmation.OPTION_YES) {
            accessOK.add(context);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveRepository(LicenseRepository repository, ILocator locator) throws IOException {
        OutputStream os = null;
        try {
            os = locator.getOutputStream();
            XMLSerializationContext context = new XMLSerializationContext(os, false);
            LicenseContainerSerializer serializer = new LicenseContainerSerializer((SerializationContext)context);
            serializer.serialize(repository);
        }
        finally {
            StreamTools.close((Closeable)os);
        }
    }

    private LicenseTools() {
    }

    static {
        try {
            parser = SAXTools.createSecureParserFactory().newSAXParser();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error creating SAXParser", e);
        }
        accessOK = new HashSet();
        Log = LoggerFactory.getLogger(LicenseTools.class);
    }
}

