/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.license.LicenseAccount;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicensePropertyUnitPerTime;
import de.intarsys.tools.license.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import java.time.Instant;
import java.time.ZonedDateTime;

public class LicensePropertyUnitPerMonth
extends LicensePropertyUnitPerTime {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final long MILLISPERMONTH = 2592000000L;

    @Override
    protected long getAccountingPeriod() {
        return 2592000000L;
    }

    @Override
    public String getId() {
        return "month";
    }

    @Override
    public String getLabel() {
        return Msg.getString("LicensePropertyUnitPerMonth.Label", new Object[0]);
    }

    @Override
    protected Instant getNextReset(Instant lastAccess) {
        ZonedDateTime dateTime = lastAccess.atZone(CachedZoneId);
        dateTime = dateTime.plusMonths(1L);
        ZonedDateTime nextReset = ZonedDateTime.of(dateTime.getYear(), dateTime.getMonthValue(), 1, 0, 0, 0, 0, CachedZoneId);
        return nextReset.toInstant();
    }

    @Override
    protected void handleRestrictionExceededDefault(LicenseAccount account, int maxTokens, float spentTokens) throws LicenseException {
        this.delay(account, maxTokens, 60000);
    }
}

