/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.concurrent.ForwardedThreadLocal;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.license.EnumLicenseState;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.License;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicenseProperty;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseRepository;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.locator.ClassLoaderResourceLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.servicelocator.ServiceLocator;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SingletonProvider
public final class LicenseEnvironment {
    public static final String LICPROP_BUNDLE = "bundle";
    public static final String LICPROPVALUE_BACKSTAGE = "backstage";
    public static final String LICPROPVALUE_BASIC = "basic";
    public static final String LICPROPVALUE_TRUE = "true";
    public static final String LICPROPVALUE_PROFESSIONAL = "professional";
    private static final Logger Log = LoggerFactory.getLogger(LicenseEnvironment.class);
    public static final int DEFAULTPERMINUTE = 10;
    private LicenseProduct product;
    @Inject
    private List<LicenseProduct> products = new ArrayList<LicenseProduct>();
    private ILocator publicKeyLocator;
    private PublicKey publicKey;
    private File licenseImportDir;
    private final ThreadLocal<Deque<LicenseRepository>> repositories = new ForwardedThreadLocal(){

        protected Deque<LicenseRepository> initialValue() {
            return new ArrayDeque<LicenseRepository>();
        }
    };
    private final LicenseRepository licenseRepositoryRoot = new LicenseRepository(this);
    private final List<Object> automationHandles = new ArrayList<Object>();

    public static LicenseEnvironment get() {
        return (LicenseEnvironment)ServiceLocator.get().get(LicenseEnvironment.class);
    }

    public LicenseEnvironment() {
        this.setPublicKeyLocator((ILocator)new ClassLoaderResourceLocator(this.getClass().getClassLoader(), "certs/license.cert"));
    }

    public void attachLicenseRepository(LicenseRepository repo) {
        Deque<LicenseRepository> stack = this.repositories.get();
        stack.push(repo);
    }

    protected File createLicenseImportDirectory() {
        File globalDir = null;
        File localDir = null;
        try {
            globalDir = new File(FileEnvironment.get().getBaseDir(), "licenses");
            FileTools.mkdirs((File)globalDir);
            File testFile = File.createTempFile("test", ".test", globalDir);
            testFile.delete();
            return globalDir;
        }
        catch (Exception ioe) {
            localDir = new File(FileEnvironment.get().getProfileDir(), "licenses");
            try {
                FileTools.mkdirs((File)localDir);
                File testFile = File.createTempFile("test", ".test", localDir);
                testFile.delete();
                Log.warn("can't write to license directory '" + globalDir + "', switch to local directory '" + localDir + "'");
                return localDir;
            }
            catch (IOException iOException) {
                Log.warn("can't write to license directories '" + globalDir + "' or '" + localDir + "'");
                return null;
            }
        }
    }

    public LicenseRepository createLicenseRepository() {
        return new LicenseRepository(this);
    }

    protected byte[] decrypt(byte[] key) {
        return LicenseTools.decrypt(key, this.getPublicKey());
    }

    public void delete() {
        this.getLicenseRepositoryRoot().reset();
        if (FileEnvironment.get() == null) {
            return;
        }
        File dir = new File(FileEnvironment.get().getBaseDir(), "licenses");
        try {
            FileTools.deleteRecursivly((File)dir, (boolean)false);
        }
        catch (IOException e) {
            Log.warn("failed to delete license dir {}", (Object)dir, (Object)e);
        }
        dir = new File(FileEnvironment.get().getProfileDir(), "licenses");
        try {
            FileTools.deleteRecursivly((File)dir, (boolean)false);
        }
        catch (IOException e) {
            Log.warn("failed to delete license dir {}", (Object)dir, (Object)e);
        }
    }

    public void detachLicenseRepository() {
        Deque<LicenseRepository> stack = this.repositories.get();
        stack.pop();
    }

    public File getLicenseImportDir() {
        if (this.licenseImportDir == null) {
            this.licenseImportDir = this.createLicenseImportDirectory();
        }
        return this.licenseImportDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseProduct getLicenseProduct() {
        List<LicenseProduct> list = this.products;
        synchronized (list) {
            if (this.product == null) {
                for (LicenseProduct tempProduct : this.products) {
                    if (!tempProduct.isMain()) continue;
                    if (this.product != null) {
                        throw new LicenseException("illegal license definition");
                    }
                    this.product = tempProduct;
                }
            }
            return this.product;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LicenseProduct> getLicenseProducts() {
        List<LicenseProduct> list = this.products;
        synchronized (list) {
            return new ArrayList<LicenseProduct>(this.products);
        }
    }

    public EnumLicenseState getLicenseProductState(LicenseProduct product) {
        if (product == null) {
            return EnumLicenseState.NA;
        }
        if (product.isFree()) {
            return EnumLicenseState.VALID;
        }
        List<License> licenses = this.getLicenses();
        return LicenseTools.getLicensePropertyWithValueState(licenses, "id", product.getId());
    }

    public List<LicenseProperty> getLicenseProperties(LicenseProduct product, String propertyName) {
        List<License> licenses = this.getLicensesAuthorized(product);
        return LicenseTools.getLicenseProperties(licenses, propertyName);
    }

    public List<LicenseProperty> getLicensePropertiesGlobal(String propertyName) {
        List<License> licenses = this.getLicensesAuthorized();
        return LicenseTools.getLicenseProperties(licenses, propertyName);
    }

    public LicenseProperty getLicensePropertyMax(LicenseProduct product, String propertyName) {
        if (product == null) {
            return null;
        }
        List<License> licenses = this.getLicensesAuthorized(product);
        return LicenseTools.getLicensePropertyMax(licenses, propertyName);
    }

    public LicenseProperty getLicensePropertyMaxGlobal(String propertyName) {
        List<License> licenses = this.getLicensesAuthorized();
        return LicenseTools.getLicensePropertyMax(licenses, propertyName);
    }

    public EnumLicenseState getLicensePropertyWithValueState(LicenseProduct product, String property, String value) {
        if (product == null) {
            return EnumLicenseState.NA;
        }
        List<License> licenses = this.getLicensesAuthorized(product);
        return LicenseTools.getLicensePropertyWithValueState(licenses, property, value);
    }

    public EnumLicenseState getLicensePropertyWithValueStateGlobal(String property, String value) {
        List<License> licenses = this.getLicenses();
        return LicenseTools.getLicensePropertyWithValueState(licenses, property, value);
    }

    public LicenseRepository getLicenseRepositoryActive() {
        Deque<LicenseRepository> stack = this.repositories.get();
        LicenseRepository object = stack.peek();
        return object == null ? this.getLicenseRepositoryRoot() : object;
    }

    public LicenseRepository getLicenseRepositoryRoot() {
        return this.licenseRepositoryRoot;
    }

    public List<License> getLicenses() {
        ArrayList<License> result = new ArrayList<License>();
        Deque<LicenseRepository> stack = this.repositories.get();
        for (LicenseRepository repo : stack) {
            result.addAll(repo.getLicenses());
        }
        result.addAll(this.getLicenseRepositoryRoot().getLicenses());
        return result;
    }

    public List<License> getLicenses(LicenseProduct product) {
        if (product == null) {
            return Collections.EMPTY_LIST;
        }
        String productId = product.getId();
        return this.getLicenses().stream().filter(license -> productId.equals(license.getProductId())).toList();
    }

    public List<License> getLicensesAuthorized() {
        return this.getLicenses().stream().filter(license -> {
            LicenseProduct product = this.lookupProduct(license.getProductId());
            return license.getState(product).isAuthorized();
        }).toList();
    }

    public List<License> getLicensesAuthorized(LicenseProduct product) {
        if (product == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getLicenses(product).stream().filter(license -> license.getState(product).isAuthorized()).toList();
    }

    private PublicKey getPublicKey() throws LicenseException {
        if (this.publicKey == null) {
            this.publicKey = this.readPublicKey();
        }
        return this.publicKey;
    }

    public ILocator getPublicKeyLocator() {
        return this.publicKeyLocator;
    }

    public void importLicense(ILocator locator) throws LicenseException {
        List<License> licenses = LicenseTools.loadLicense(locator);
        long count = licenses.stream().filter(license -> this.getLicenseRepositoryRoot().addLicense((License)license)).count();
        if (count == 0L) {
            return;
        }
        File dir = this.getLicenseImportDir();
        if (dir == null) {
            throw new LicenseException("missing license import directory");
        }
        try {
            String basename = LocatorTools.getBaseName((ILocator)locator);
            String extension = LocatorTools.getExtension((ILocator)locator);
            File newLicenseFile = File.createTempFile(basename + "_", extension, dir);
            LocatorTools.copy((ILocator)locator, (ILocator)new FileLocator(newLicenseFile));
        }
        catch (IOException e) {
            throw new LicenseException("can not import license '" + locator.getPath() + "'", e);
        }
    }

    @PostConstruct
    public void install() {
        LicenseProduct.installStandardProducts();
        this.registerProduct(LicenseProduct.GLOBAL);
        this.registerProduct(LicenseProduct.NA);
    }

    public final boolean isAuthorized() {
        Deque<LicenseRepository> stack = this.repositories.get();
        for (LicenseRepository repo : stack) {
            if (!repo.isAuthorized()) continue;
            return true;
        }
        return this.getLicenseRepositoryRoot().isAuthorized();
    }

    public boolean isAuthorizedAutomation() {
        if (!this.isAutomation()) {
            return true;
        }
        return this.isAuthorizedProfessional();
    }

    public final boolean isAuthorizedBasic() {
        Deque<LicenseRepository> stack = this.repositories.get();
        for (LicenseRepository repo : stack) {
            if (!repo.isAuthorized(LICPROPVALUE_BASIC)) continue;
            return true;
        }
        return this.getLicenseRepositoryRoot().isAuthorized(LICPROPVALUE_BASIC);
    }

    public final boolean isAuthorizedFeature(String feature) {
        return this.getLicensePropertyWithValueStateGlobal(feature, LICPROPVALUE_TRUE).isAuthorized();
    }

    public final boolean isAuthorizedProfessional() {
        Deque<LicenseRepository> stack = this.repositories.get();
        for (LicenseRepository repo : stack) {
            if (!repo.isAuthorized(LICPROPVALUE_PROFESSIONAL)) continue;
            return true;
        }
        return this.getLicenseRepositoryRoot().isAuthorized(LICPROPVALUE_PROFESSIONAL);
    }

    public boolean isAutomation() {
        List<Object> handles = this.automationHandles;
        return handles.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseProduct lookupProduct(String productId) {
        if (StringTools.isEmpty((String)productId)) {
            return null;
        }
        List<LicenseProduct> list = this.products;
        synchronized (list) {
            for (LicenseProduct product : this.products) {
                if (!product.getId().equals(productId)) continue;
                return product;
            }
            return LicenseProduct.NA;
        }
    }

    private PublicKey readPublicKey() throws LicenseException {
        InputStream cis = null;
        X509Certificate certificate = null;
        try {
            cis = this.getPublicKeyLocator().getInputStream();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            certificate = (X509Certificate)cf.generateCertificate(cis);
            PublicKey publicKey = certificate.getPublicKey();
            return publicKey;
        }
        catch (FileNotFoundException e) {
            throw new LicenseException("certificate not found");
        }
        catch (CertificateException e) {
            throw new LicenseException("wrong format of certificate: " + e.getMessage());
        }
        catch (IOException e) {
            throw new LicenseException("certificate: " + e.getMessage());
        }
        finally {
            StreamTools.close((Closeable)cis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseProduct registerProduct(LicenseProduct product) {
        List<LicenseProduct> list = this.products;
        synchronized (list) {
            product.seal();
            LicenseProduct tmpProduct = this.lookupProduct(product.getId());
            if (tmpProduct == LicenseProduct.NA) {
                Log.info("register license product {}, version {}", (Object)product.getId(), (Object)product.getVersion());
                this.products.add(product);
                return product;
            }
            return tmpProduct;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.repositories.remove();
        this.licenseRepositoryRoot.reset();
        List<LicenseProduct> list = this.products;
        synchronized (list) {
            this.products.clear();
            this.product = null;
        }
    }

    public void setLicenseImportDir(File importLicenseDir) {
        this.licenseImportDir = importLicenseDir;
    }

    public void setPublicKeyLocator(ILocator publicKeyLocator) {
        if (this.publicKeyLocator != null) {
            throw new LicenseException("license tampering");
        }
        this.publicKeyLocator = publicKeyLocator;
    }

    public Object startAutomation(String property) throws LicenseException {
        Object handle = new Object();
        this.automationHandles.add(handle);
        LicenseProduct.GLOBAL.getAccount(property).setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        ILicenseAccount account = LicenseProduct.GLOBAL.getAccount(property);
        account.reserve(1).commit();
        return handle;
    }

    public boolean stopAutomation(Object handle) {
        if (handle == null) {
            return false;
        }
        return this.automationHandles.remove(handle);
    }

    public LicenseProduct toProduct(Object value) {
        if (value instanceof LicenseProduct) {
            return (LicenseProduct)value;
        }
        if (value instanceof String) {
            return this.lookupProduct((String)value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterProduct(LicenseProduct product) {
        List<LicenseProduct> list = this.products;
        synchronized (list) {
            this.products.remove(product);
        }
    }
}

