/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.jca.device;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IX509Principal;
import de.intarsys.security.jca.device.DevicePrivateKeyEC;
import de.intarsys.security.jca.device.DevicePrivateKeyRSA;
import de.intarsys.tools.crypto.Secret;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;

public abstract class DevicePrivateKey
implements PrivateKey {
    private final IDevice device;
    private final IX509Principal principal;
    private final Secret password;

    public static DevicePrivateKey create(IDevice signerDevice, IX509Principal signerPrincipal, Secret password) {
        IX509PublicKeyCertificate signerCertificate = signerPrincipal.getX509PublicKeyCertificate();
        if (signerCertificate == null) {
            return null;
        }
        if (signerCertificate.getPublicKey() instanceof RSAKey) {
            return new DevicePrivateKeyRSA(signerDevice, signerPrincipal, password);
        }
        if (signerCertificate.getPublicKey() instanceof ECKey) {
            return new DevicePrivateKeyEC(signerDevice, signerPrincipal, password);
        }
        return null;
    }

    protected DevicePrivateKey(IDevice device, IX509Principal principal, Secret password) {
        this.device = device;
        this.principal = principal;
        this.password = password;
    }

    @Override
    public String getAlgorithm() {
        return this.getPrincipal().getJavaCertificate().getPublicKey().getAlgorithm();
    }

    public IDevice getDevice() {
        return this.device;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    public Secret getPassword() {
        return this.password;
    }

    public IX509Principal getPrincipal() {
        return this.principal;
    }

    public PublicKey getSignerPublicKey() {
        IX509PublicKeyCertificate certificate = this.getPrincipal().getX509PublicKeyCertificate();
        if (certificate == null) {
            return null;
        }
        return certificate.getPublicKey();
    }
}

