/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.health;

import de.intarsys.security.device.health.CommonHealthMonitor;
import de.intarsys.security.device.health.IHealthMonitorTarget;
import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class ConcurrentHealthMonitor<T extends IHealthMonitorTarget>
extends CommonHealthMonitor<T> {
    private ScheduledExecutorService executor;
    private int delay;

    public ConcurrentHealthMonitor() {
        this.setDelay(this.getDefaultDelay());
    }

    @Override
    protected void basicStart() {
        if (this.isEnabled()) {
            this.basicStartEnabled();
        }
    }

    protected void basicStartEnabled() {
        this.executor = new ScheduledThreadPoolExecutor(1, ThreadTools.newThreadFactoryDaemon((String)("health monitor " + this.getTarget())));
        this.executor.scheduleWithFixedDelay(this::monitor, this.getDelay(), this.getDelay(), TimeUnit.SECONDS);
    }

    @Override
    protected void basicStop() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    protected int getDefaultDelay() {
        return 290;
    }

    public int getDelay() {
        return this.delay;
    }

    protected boolean isEnabled() {
        return this.getDelay() > 0;
    }

    protected abstract void monitor();

    @Override
    public void setArgs(IArgs args) {
        super.setArgs(args);
        this.setDelay(ArgTools.getInt((IArgs)args, (String)"delay", (int)this.getDefaultDelay()));
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }
}

