/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificateOwner;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IPrincipalFilter;

public class CertificateIdentityPrincipalFilter
implements IPrincipalFilter {
    private final IX509Certificate certificate;

    public CertificateIdentityPrincipalFilter(IX509Certificate certificate) {
        this.certificate = certificate;
    }

    @Override
    public boolean accept(IPrincipal principal) {
        if (principal instanceof IX509PublicKeyCertificateOwner) {
            IX509PublicKeyCertificateOwner co = (IX509PublicKeyCertificateOwner)principal;
            IX509PublicKeyCertificate otherCert = co.getX509PublicKeyCertificate();
            return this.getCertificate().equals(otherCert);
        }
        return false;
    }

    public IX509Certificate getCertificate() {
        return this.certificate;
    }
}

