/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.authentication;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.authentication.IAuthenticator;
import de.intarsys.security.app.common.CommonSecurityApplication;
import de.intarsys.security.app.validation.ValidationTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.common.CommonDevice;

public abstract class CommonAuthenticator
extends CommonSecurityApplication
implements IAuthenticator {
    private IX509PublicKeyCertificate[] certificatePath;

    protected CommonAuthenticator(CommonDevice device) {
        super(device);
    }

    protected abstract byte[] basicSign(byte[] var1) throws SecurityApplicationException;

    @Override
    public void buildCertificatePath() {
        if (this.getCertificate() == null) {
            this.certificatePath = new IX509PublicKeyCertificate[0];
            return;
        }
        IX509Certificate[] path = ValidationTools.getCertificatePath((IX509Certificate)this.getCertificate());
        if (path == null || path.length == 0) {
            this.certificatePath = new IX509PublicKeyCertificate[]{this.getCertificate()};
        } else {
            this.certificatePath = new IX509PublicKeyCertificate[path.length];
            System.arraycopy(path, 0, this.certificatePath, 0, path.length);
        }
    }

    protected IX509PublicKeyCertificate getCertificate() {
        if (this.getCertificatePath() == null || this.getCertificatePath().length == 0) {
            return null;
        }
        return this.getCertificatePath()[0];
    }

    @Override
    public IX509PublicKeyCertificate[] getCertificatePath() {
        return this.certificatePath;
    }

    @Override
    public String getIconName() {
        return "security/authenticator";
    }

    protected int getKeyBitSize() {
        if (this.getCertificate() == null) {
            return 0;
        }
        return this.getCertificate().getKeyBitSize();
    }

    protected int getKeyByteSize() {
        if (this.getCertificate() == null) {
            return 0;
        }
        int bitSize = this.getCertificate().getKeyBitSize();
        return (bitSize + 7) / 8;
    }

    @Override
    public String getLabel() {
        return "Authentication application";
    }

    protected void setCertificatePath(IX509PublicKeyCertificate[] certificatePath) {
        this.certificatePath = certificatePath;
    }

    @Override
    public final byte[] sign(byte[] data) throws SecurityApplicationException {
        byte[] result = this.basicSign(data);
        this.incUseCount();
        return result;
    }
}

