/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.table;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.table.ITableColumn;
import de.intarsys.tools.table.ITableRecord;
import de.intarsys.tools.table.ITableRecordProcessor;
import de.intarsys.tools.table.ITableType;
import de.intarsys.tools.table.TableColumn;
import de.intarsys.tools.table.TableProcessingException;
import de.intarsys.tools.table.TableProcessor;
import de.intarsys.tools.table.TableType;
import java.util.Iterator;
import java.util.List;

public class TableProcessorView<R>
extends TableProcessor<R> {
    private static final String EL_COLUMN = "column";
    private static final String EL_COLUMNS = "columns";
    private TableType viewType = new TableType();

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        this.viewType = new TableType();
        IElement elColumns = element.element(EL_COLUMNS);
        if (elColumns != null) {
            Iterator itColumn = elColumns.elementIterator(EL_COLUMN);
            while (itColumn.hasNext()) {
                IElement elColumn = (IElement)itColumn.next();
                try {
                    TableColumn column = (TableColumn)ElementTools.createObject((IElement)elColumn, TableColumn.class, (Object)this, (IArgs)Args.create());
                    this.viewType.addColumn(column);
                }
                catch (ObjectCreationException objectCreationException) {}
            }
        }
    }

    protected ITableRecord createView(ITableRecord item) throws TableProcessingException {
        ITableRecord viewRecord = this.getViewType().createRecord();
        for (ITableColumn column : this.getViewType().getColumns()) {
            ITableRecordProcessor<?> function = column.getFunction();
            viewRecord.put(column.getName(), function.process(item));
        }
        return viewRecord;
    }

    @Override
    protected ITableType getChainedType() {
        return new ITableType(){

            @Override
            public ITableRecord createRecord() {
                ITableRecord tableRecord = TableProcessorView.this.getActiveType().createRecord();
                try {
                    return TableProcessorView.this.createView(tableRecord);
                }
                catch (TableProcessingException e) {
                    return tableRecord;
                }
            }

            @Override
            public List<ITableColumn> getColumns() {
                return TableProcessorView.this.getViewType().getColumns();
            }

            @Override
            public String getId() {
                return TableProcessorView.this.getViewType().getId();
            }
        };
    }

    public TableType getViewType() {
        return this.viewType;
    }

    @Override
    public void open(ITableType type) throws TableProcessingException {
        super.open(type);
        this.viewType.setId(type.getId());
    }

    @Override
    public R process(ITableRecord item) throws TableProcessingException {
        ITableRecord viewRecord = this.createView(item);
        return super.process(viewRecord);
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        super.serialize(element);
        IElement elColumns = element.newElementMapped(EL_COLUMNS);
        for (ITableColumn column : this.viewType.getColumns()) {
            IElement elColumn = elColumns.newElementMapped(EL_COLUMN);
            ((IElementSerializable)column).serialize(elColumn);
        }
    }
}

