/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences.common;

import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.preferences.common.ExtendedPreferences;
import de.intarsys.tools.preferences.common.ILocatorPreferencesPersistence;
import de.intarsys.tools.preferences.common.LocatorPreferencesImpl;
import de.intarsys.tools.preferences.common.XMLPreferencesPersistence;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;

public class RootLocatorPreferencesImpl
extends ExtendedPreferences {
    private static final String EXT_PREFS = ".prefs";
    private ILocatorPreferencesPersistence persistence = new XMLPreferencesPersistence();
    private ILocator rootLocator;

    public RootLocatorPreferencesImpl(ExtendedPreferences parent, String name) {
        super(parent, name);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        if (this.rootLocator == null) {
            return new String[0];
        }
        try {
            ILocator[] locators = this.getRootLocator().listLocators(new ILocatorNameFilter(){

                public boolean accept(ILocator parent, String name) {
                    return name.endsWith(RootLocatorPreferencesImpl.EXT_PREFS);
                }
            });
            String[] result = new String[locators.length];
            for (int i = 0; i < locators.length; ++i) {
                String localName;
                ILocator locator = locators[i];
                result[i] = localName = LocatorTools.getBaseName((ILocator)locator);
            }
            return result;
        }
        catch (FileNotFoundException e) {
            return new String[0];
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        LocatorPreferencesImpl newPrefs = new LocatorPreferencesImpl(this, name);
        newPrefs.setPersistence(this.getPersistence());
        if (this.rootLocator != null) {
            ILocator childLocator = this.rootLocator.getChild(name + EXT_PREFS);
            newPrefs.setLocator(childLocator);
        }
        return newPrefs;
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        if (this.getRootLocator() == null) {
            return;
        }
        AbstractPreferences[] children = this.cachedChildren();
        for (int i = 0; i < children.length; ++i) {
            AbstractPreferences child = children[i];
            child.flush();
        }
    }

    public ILocatorPreferencesPersistence getPersistence() {
        return this.persistence;
    }

    public ILocator getRootLocator() {
        return this.rootLocator;
    }

    @Override
    protected String getSpi(String key) {
        return null;
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        return new String[0];
    }

    @Override
    protected void putSpi(String key, String value) {
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
    }

    @Override
    protected void removeSpi(String key) {
    }

    public void setPersistence(ILocatorPreferencesPersistence persistence) {
        this.persistence = persistence;
    }

    public void setRootLocator(ILocator rootLocator) {
        this.rootLocator = rootLocator;
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
    }
}

