/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.xml;

import de.intarsys.tools.exception.UnreachableCodeError;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.xml.EntityDecoder;
import de.intarsys.tools.xml.HTMLEncodeLineBreaks;
import de.intarsys.tools.xml.TransformerTools;
import de.intarsys.tools.xml.XMLEncodeSpecialChars;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.function.UnaryOperator;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class XMLTools {
    private static final int DEFAULT_INDENT_AMOUNT = 4;

    public static String decodeSpecialChars(String encodedString) throws IOException {
        try (EntityDecoder decoder = new EntityDecoder(new StringReader(encodedString), false);){
            String string = StreamTools.getString(decoder);
            return string;
        }
    }

    public static String encodeDefault(String plainString) {
        return XMLTools.encode(plainString, reader -> new HTMLEncodeLineBreaks(new XMLEncodeSpecialChars((Reader)reader)));
    }

    public static String encodeLineBreaks(String plainString) {
        return XMLTools.encode(plainString, HTMLEncodeLineBreaks::new);
    }

    public static String encodeSpecialChars(String plainString) {
        return XMLTools.encode(plainString, XMLEncodeSpecialChars::new);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String encode(String input, UnaryOperator<Reader> encoderFactory) {
        try (Reader reader = (Reader)encoderFactory.apply(new StringReader(input));){
            String string;
            try (StringWriter writer = new StringWriter();){
                StreamTools.copy(reader, writer);
                string = ((Object)writer).toString();
            }
            return string;
        }
        catch (IOException exception) {
            throw new UnreachableCodeError("String readers and writers should not throw IOExceptions", exception);
        }
    }

    public static String serialize(Node node) {
        String string;
        StringWriter output = new StringWriter();
        try {
            Transformer transformer = TransformerTools.createSecureTransformerFactory().newTransformer();
            transformer.transform(new DOMSource(node), new StreamResult(output));
            string = output.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | TransformerException exception) {
                throw new UnreachableCodeError("Should never happen with a wellformed Document and a StringWriter", exception);
            }
        }
        output.close();
        return string;
    }

    public static String prettyPrint(Node node) {
        String string;
        StringWriter output = new StringWriter();
        try {
            XMLTools.prettyPrint(new DOMSource(node), new StreamResult(output));
            string = output.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | TransformerException exception) {
                throw new UnreachableCodeError("Should never happen with a wellformed Node and a StringWriter", exception);
            }
        }
        output.close();
        return string;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String prettyPrint(String xml) {
        try (StringReader input = new StringReader(xml);){
            String string;
            try (StringWriter output = new StringWriter();){
                XMLTools.prettyPrint(new StreamSource(input), new StreamResult(output));
                string = output.toString();
            }
            return string;
        }
        catch (IOException | TransformerException exception) {
            return xml;
        }
    }

    public static void prettyPrint(Source source, Result result) throws TransformerException {
        Transformer transformer = TransformerTools.createSecureTransformerFactory().newTransformer();
        TransformerTools.setIndentAmount(transformer, 4);
        transformer.transform(source, result);
    }

    private XMLTools() {
    }
}

