/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tlv.common;

import de.intarsys.tools.tlv.common.SimpleElement;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SimpleInputStream
extends TlvInputStream {
    public SimpleInputStream(byte[] data, int offset, int length) {
        this(new ByteArrayInputStream(data, offset, length));
    }

    public SimpleInputStream(InputStream in) {
        super(in);
    }

    @Override
    public TlvElement readElement() throws IOException {
        int i = this.read();
        while (i == 0) {
            i = this.read();
        }
        if (i == -1) {
            return null;
        }
        int tag = i;
        i = this.read();
        if (i == -1) {
            throw new IOException("unexpected end of input");
        }
        int length = i;
        if (length == 255) {
            i = this.read();
            if (i == -1) {
                throw new IOException("unexpected end of input");
            }
            length = i;
            i = this.read();
            if (i == -1) {
                throw new IOException("unexpected end of input");
            }
            length = (length << 8) + i;
        }
        byte[] data = new byte[length];
        int offset = 0;
        while (length > 0 && (i = this.read(data, offset, length)) != -1) {
            offset += i;
            length -= i;
        }
        if (length != 0) {
            throw new IOException("unexpected end of input (data missing)");
        }
        return new SimpleElement(tag, data);
    }
}

