/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tag;

import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.tag.Tag;
import de.intarsys.tools.tag.TagTools;
import de.intarsys.tools.zones.Zone;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagsToArgsFunctor
implements IFunctor {
    private static final Logger Log = LoggerFactory.getLogger(TagsToArgsFunctor.class);

    public Object perform(IFunctorCall call) throws FunctorException {
        IArgs args = call.getArgs();
        IArgs resultArgs = ArgTools.getArgs(args, "args", null);
        if (resultArgs == null) {
            resultArgs = args;
        }
        String prefix = ArgTools.getString(args, "prefix", "args.");
        List<Tag> tags = ArgTools.getList(args, "tags", null);
        if (tags == null) {
            Object target = ArgTools.getObject(args, "target", null);
            if (target == null) {
                target = Zone.getCurrent();
            }
            tags = TagTools.getTagList(target);
        }
        for (Object e : tags) {
            Tag tag;
            if (e instanceof Tag) {
                tag = (Tag)e;
            } else {
                if (!(e instanceof String)) continue;
                try {
                    tag = TagTools.parseTag((String)e);
                }
                catch (IOException e2) {
                    Log.warn("tag cannot be parsed {}", e);
                    continue;
                }
            }
            String key = tag.getKey();
            String value = tag.getValue();
            if (!key.startsWith(prefix)) continue;
            ArgTools.putPath(resultArgs, key.substring(prefix.length()), value);
        }
        return resultArgs;
    }
}

