/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LogInputStream
extends FilterInputStream {
    private OutputStream log;

    public LogInputStream(InputStream newin, OutputStream newlog) {
        super(newin);
        this.setLog(newlog);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.log != null) {
            this.log.close();
        }
    }

    public OutputStream getLog() {
        return this.log;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b > -1 && this.log != null) {
            this.log.write(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytes = super.read(b, off, len);
        if (bytes > -1 && this.log != null) {
            this.log.write(b, off, bytes);
        }
        return bytes;
    }

    public void setLog(OutputStream newLog) {
        this.log = newLog;
    }
}

