/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.stream;

import de.intarsys.tools.string.StringTools;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HexDumpStream
extends FilterOutputStream {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int BYTES_PER_LINE = 16;
    private int tbc;
    private int lbc;
    private final char[] line = new char[16];

    public HexDumpStream(OutputStream out) {
        super(out);
    }

    @Override
    public void flush() throws IOException {
        int i;
        String tbcString = Long.toHexString(this.tbc);
        for (i = tbcString.length(); i < 8; ++i) {
            this.out.write(48);
        }
        this.out.write(tbcString.getBytes());
        this.out.write(32);
        for (i = 0; i < this.lbc; ++i) {
            this.out.write(HEX[this.line[i] >> 4 & 0xF]);
            this.out.write(HEX[this.line[i] >> 0 & 0xF]);
            this.out.write(32);
        }
        while (i < 16) {
            this.out.write(32);
            this.out.write(32);
            this.out.write(32);
            ++i;
        }
        this.out.write(32);
        for (i = 0; i < this.lbc; ++i) {
            if (Character.isISOControl(this.line[i])) {
                this.out.write(46);
                continue;
            }
            this.out.write(this.line[i]);
        }
        this.out.write(StringTools.LS.getBytes());
        this.tbc += this.lbc;
        this.lbc = 0;
        super.flush();
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.line[this.lbc++] = (char)b;
        if (this.lbc >= 16) {
            this.flush();
        }
    }
}

