/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.state;

import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.IMessageBundleSupport;
import de.intarsys.tools.state.AtomicState;
import de.intarsys.tools.state.CommonState;
import de.intarsys.tools.state.ConcurrentState;
import de.intarsys.tools.state.IState;
import de.intarsys.tools.state.IStateHolder;
import de.intarsys.tools.state.StateVector;

public class ComplexStateHolder
implements IStateHolder,
IMessageBundleSupport {
    private StateVector stateVector = new StateVector();
    private final Object owner;
    private final INotificationListener listener;
    private IMessageBundle messageBundle;

    public ComplexStateHolder(Object owner, INotificationListener listener) {
        this.owner = owner;
        this.listener = listener;
        this.enterState(AtomicState.NEW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enterState(IState pState) {
        ConcurrentState newState;
        if (pState == null) {
            throw new NullPointerException();
        }
        if (!(pState instanceof CommonState)) {
            throw new IllegalArgumentException();
        }
        IState oldState = null;
        ComplexStateHolder complexStateHolder = this;
        synchronized (complexStateHolder) {
            if (pState == this.stateVector) {
                return;
            }
            StateVector expiredState = this.stateVector;
            ConcurrentState cState = ConcurrentState.create((CommonState)pState);
            oldState = this.stateVector.lookupState(cState.getContext());
            cState = (ConcurrentState)cState.attach(this);
            this.stateVector = this.stateVector.putState(cState);
            newState = cState;
            expiredState.attach(null);
        }
        this.triggerChanged("state", oldState, newState);
    }

    @Override
    public IMessageBundle getMessageBundle() {
        if (this.messageBundle != null) {
            return this.messageBundle;
        }
        if (this.owner instanceof IMessageBundleSupport) {
            return ((IMessageBundleSupport)this.owner).getMessageBundle();
        }
        return null;
    }

    @Override
    public IState getState() {
        return this.getStateVector().unwrap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateVector getStateVector() {
        ComplexStateHolder complexStateHolder = this;
        synchronized (complexStateHolder) {
            return this.stateVector;
        }
    }

    public void setMessageBundle(IMessageBundle messageBundle) {
        this.messageBundle = messageBundle;
    }

    public String toString() {
        return "StateHolder@" + this.getStateVector().getId();
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        if (this.listener != null) {
            this.listener.handleEvent(new AttributeChangedEvent(this.owner, attribute, oldValue, newValue));
        }
    }
}

