/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.resourcetracker;

import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.resourcetracker.IResourceReference;
import de.intarsys.tools.resourcetracker.PhantomResourceReference;
import java.lang.ref.ReferenceQueue;

@SingletonClass
public class ResourceFinalizer
extends Thread {
    private static ResourceFinalizer DEFAULT;
    private final ReferenceQueue queue = new ReferenceQueue();
    private boolean started;

    public static synchronized ResourceFinalizer get() {
        if (DEFAULT == null) {
            DEFAULT = new ResourceFinalizer();
        }
        return DEFAULT;
    }

    public ResourceFinalizer() {
        super("resource finalizer");
        this.setDaemon(true);
    }

    protected void drainQueue() {
        IResourceReference ref;
        while ((ref = (IResourceReference)((Object)this.queue.poll())) != null) {
            ref.dispose();
        }
        return;
    }

    protected synchronized void ensureStarted() {
        if (this.started) {
            return;
        }
        this.start();
    }

    public ReferenceQueue getQueue() {
        return this.queue;
    }

    @Override
    public void run() {
        try {
            while (true) {
                PhantomResourceReference ref;
                if ((ref = (PhantomResourceReference)this.queue.remove()) == null) {
                    continue;
                }
                ref.dispose();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
        }
    }

    @Override
    public synchronized void start() {
        this.started = true;
        super.start();
    }
}

