/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.reflect.MethodCancelledException;
import de.intarsys.tools.reflect.MethodExecutionException;
import de.intarsys.tools.reflect.ReflectionException;

public abstract class MethodException
extends ReflectionException {
    private final String name;

    public static MethodException create(Throwable t) {
        if (ExceptionTools.isCancellation(t)) {
            return new MethodCancelledException(t.getLocalizedMessage());
        }
        return new MethodExecutionException(t.getLocalizedMessage(), t);
    }

    protected MethodException(Class clazz, String name) {
        super(clazz);
        this.name = name;
    }

    protected MethodException(Class clazz, String name, String message) {
        super(clazz, message);
        this.name = name;
    }

    protected MethodException(Class clazz, String name, String message, Throwable cause) {
        super(clazz, message, cause);
        this.name = name;
    }

    protected MethodException(Class clazz, String name, Throwable cause) {
        super(clazz, cause);
        this.name = name;
    }

    protected MethodException(String name) {
        super((Class)null);
        this.name = name;
    }

    protected MethodException(String name, String message) {
        super(null, message);
        this.name = name;
    }

    protected MethodException(String name, String message, Throwable cause) {
        super(null, message, cause);
        this.name = name;
    }

    protected MethodException(String name, Throwable cause) {
        super((Class)null, cause);
        this.name = name;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("method '");
        sb.append(this.getName());
        sb.append("'");
        if (this.getTargetClass() != null) {
            sb.append(" in ");
            sb.append(this.getTargetClass().getName());
        }
        sb.append(this.getMessageSuffix());
        if (this.getCause() != null) {
            sb.append(" (");
            sb.append(this.getCause());
            sb.append(")");
        }
        return sb.toString();
    }

    protected Object getMessageSuffix() {
        return " failed";
    }

    public String getName() {
        if (this.name == null) {
            return "<unknown>";
        }
        return this.name;
    }
}

