/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reader;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class LogReader
extends FilterReader {
    Writer log;

    public LogReader(Reader in, Writer w) {
        super(in);
        this.setLog(w);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.getLog() != null) {
            this.getLog().close();
        }
    }

    public Writer getLog() {
        return this.log;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b > -1 && this.log != null) {
            this.log.write(b);
        }
        return b;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int bytes = super.read(cbuf, off, len);
        if (bytes > -1 && this.log != null) {
            this.log.write(cbuf, off, bytes);
        }
        return bytes;
    }

    public void setLog(Writer newLog) {
        this.log = newLog;
    }
}

