/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences;

import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.valueholder.IValueHolder;
import java.util.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PrefValueHolder<T>
implements IValueHolder<T> {
    private static final Logger Log = LoggerFactory.getLogger(PrefValueHolder.class);
    private final boolean autoFlush;
    private final T defaultValue;
    private final String key;
    private final IPreferences preferences;

    protected PrefValueHolder(IPreferences preferences, String key, T defaultValue) {
        this(preferences, key, defaultValue, false);
    }

    protected PrefValueHolder(IPreferences preferences, String key, T defaultValue, boolean autoFlush) {
        this.preferences = preferences;
        this.key = key;
        this.defaultValue = defaultValue;
        this.autoFlush = autoFlush;
    }

    protected abstract void basicSet(T var1);

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public IPreferences getPreferences() {
        return this.preferences;
    }

    @Override
    public T set(T newValue) {
        this.basicSet(newValue);
        if (this.autoFlush) {
            try {
                this.getPreferences().flush();
            }
            catch (BackingStoreException ex) {
                Log.warn(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }
}

