/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.monitor.IMonitor;
import de.intarsys.tools.monitor.IMonitorRegistry;
import de.intarsys.tools.monitor.ITrace;
import java.util.Iterator;

public class MonitorOperator {
    protected void doEvent(ITrace event) {
        this.doEventStart(event);
        this.doEventBody(event);
        this.doEventEnd(event);
    }

    protected void doEventBody(ITrace event) {
    }

    protected void doEventEnd(ITrace event) {
    }

    protected void doEventStart(ITrace event) {
    }

    protected void doMonitor(IMonitor monitor) {
        this.doMonitorStart(monitor);
        this.doMonitorBody(monitor);
        this.doMonitorEnd(monitor);
    }

    protected void doMonitorBody(IMonitor monitor) {
        Iterator<ITrace> i = monitor.getTraces().iterator();
        if (i == null) {
            return;
        }
        while (i.hasNext()) {
            ITrace event = i.next();
            this.doEvent(event);
        }
    }

    protected void doMonitorEnd(IMonitor monitor) {
    }

    protected void doMonitorFactoryBody(IMonitorRegistry registry) {
        for (IMonitor monitor : registry.getMonitors()) {
            this.doMonitor(monitor);
        }
    }

    protected void doMonitorFactoryEnd(IMonitorRegistry registry) {
    }

    protected void doMonitorFactoryStart(IMonitorRegistry registry) {
    }

    protected void doMonitorStart(IMonitor monitor) {
    }

    public void process(IMonitorRegistry registry) {
        this.doMonitorFactoryStart(registry);
        this.doMonitorFactoryBody(registry);
        this.doMonitorFactoryEnd(registry);
    }
}

