/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.message.IMessageClassLoaderProvider;
import de.intarsys.tools.reflect.ClassLoaderTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

public class DirectoryMessageClassLoaderProvider
implements IMessageClassLoaderProvider {
    private String path;
    private boolean useParent = false;
    private ClassLoader classLoader = null;

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isUseParent() {
        return this.useParent;
    }

    public void setPath(String value) {
        this.path = PathTools.withTrailingSeparator(value);
        if (!StringTools.isEmpty(this.getPath())) {
            URL[] urls = ClassLoaderTools.toURLs(new File(this.getPath()));
            ClassLoader parent = this.isUseParent() ? Thread.currentThread().getContextClassLoader() : null;
            URLClassLoader cl = new URLClassLoader(urls, parent){

                @Override
                public URL getResource(String name) {
                    URL url = this.findResource(name);
                    if (url == null && this.getParent() != null) {
                        url = this.getParent().getResource(name);
                    }
                    return url;
                }
            };
            this.classLoader = cl;
        } else {
            this.classLoader = null;
        }
    }

    public void setUseParent(boolean useParent) {
        this.useParent = useParent;
    }
}

