/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.message.BasicMessageBundle;
import de.intarsys.tools.message.CommonMessageBundle;
import de.intarsys.tools.message.CommonMessageBundleFactory;
import de.intarsys.tools.reflect.ClassLoaderTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;

public class BasicMessageBundleFactory
extends CommonMessageBundleFactory {
    private Locale locale;
    private ClassLoader classloader;

    public static ClassLoader createClassLoader(ClassLoader parent, String path) throws IOException {
        if (StringTools.isEmpty(path)) {
            return null;
        }
        File file = new File(path);
        if (file.exists()) {
            URL[] urls = ClassLoaderTools.toURLs(file);
            URLClassLoader cl = new URLClassLoader(urls, parent){

                @Override
                public URL getResource(String name) {
                    URL url = this.findResource(name);
                    if (url == null && this.getParent() != null) {
                        url = this.getParent().getResource(name);
                    }
                    return url;
                }
            };
            return cl;
        }
        return null;
    }

    @Override
    protected CommonMessageBundle createMessageBundle(String name, ClassLoader pClassloader) {
        ClassLoader activeClassLoader = this.getClassloader() == null ? pClassloader : this.getClassloader();
        Locale activeLocale = this.getLocale() == null ? Locale.getDefault() : this.getLocale();
        return new BasicMessageBundle(this, name, activeLocale, activeClassLoader);
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

