/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging.slf4j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class ConsoleLogger
extends OutputStream {
    public static final PrintStream OUT = System.out;
    public static final PrintStream ERR = System.err;
    private final Logger logger;
    private final Level logLevel;
    private final OutputStream outputStream;
    private ByteArrayOutputStream os = new ByteArrayOutputStream();
    private CharsetDecoder decoder = Charset.defaultCharset().newDecoder();

    public static void install() {
        ConsoleLogger.install(LoggerFactory.getLogger((String)"System.out"), LoggerFactory.getLogger((String)"System.err"));
    }

    public static void install(Logger out, Logger err) {
        System.setOut(new PrintStreamFacade(new PrintStream(new ConsoleLogger(out, Level.DEBUG, System.out), true)));
        System.setErr(new PrintStreamFacade(new PrintStream(new ConsoleLogger(err, Level.ERROR, System.err), true)));
    }

    public ConsoleLogger(Logger logger, Level logLevel, OutputStream outputStream) {
        this.logger = logger;
        this.logLevel = logLevel;
        this.outputStream = outputStream;
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 13) {
            return;
        }
        if (b == 10) {
            this.os.write(10);
            byte[] bytes = this.os.toByteArray();
            this.os.reset();
            this.outputStream.write(bytes);
            this.logger.atLevel(this.logLevel).log(this.decoder.decode(ByteBuffer.wrap(bytes, 0, bytes.length - 1)).toString());
            return;
        }
        this.os.write(b);
    }

    static class PrintStreamFacade
    extends PrintStream {
        private final PrintStream ps;
        private boolean reentrant;

        PrintStreamFacade(PrintStream ps) {
            super(ps);
            this.ps = ps;
        }

        @Override
        public void close() {
            if (this.reentrant) {
                return;
            }
            this.reentrant = true;
            try {
                this.ps.close();
            }
            finally {
                this.reentrant = false;
            }
        }

        @Override
        public void flush() {
            if (this.reentrant) {
                return;
            }
            this.reentrant = true;
            try {
                this.ps.flush();
            }
            finally {
                this.reentrant = false;
            }
        }

        @Override
        public void println() {
            if (this.reentrant) {
                return;
            }
            this.reentrant = true;
            try {
                this.ps.println();
            }
            finally {
                this.reentrant = false;
            }
        }

        @Override
        public void println(boolean x) {
            if (this.reentrant) {
                return;
            }
            this.reentrant = true;
            try {
                this.ps.println(x);
            }
            finally {
                this.reentrant = false;
            }
        }

        @Override
        public void println(char x) {
            if (this.reentrant) {
                return;
            }
            this.reentrant = true;
            try {
                this.ps.println(x);
            }
            finally {
                this.reentrant = false;
            }
        }

        @Override
        public void println(char[] x) {
            if (this.reentrant) {
                return;
            }
            this.reentrant = true;
            try {
                this.ps.println(x);
            }
            finally {
                this.reentrant = false;
            }
        }

        @Override
        public void println(double x) {
            if (this.reentrant) {
                return;
            }
            this.reentrant = true;
            try {
                this.ps.println(x);
            }
            finally {
                this.reentrant = false;
            }
        }

        @Override
        public void println(float x) {
            if (this.reentrant) {
                return;
            }
            this.reentrant = true;
            try {
                this.ps.println(x);
            }
            finally {
                this.reentrant = false;
            }
        }

        @Override
        public void println(int x) {
            if (this.reentrant) {
                return;
            }
            this.reentrant = true;
            try {
                this.ps.println(x);
            }
            finally {
                this.reentrant = false;
            }
        }

        @Override
        public void println(long x) {
            if (this.reentrant) {
                return;
            }
            this.reentrant = true;
            try {
                this.ps.println(x);
            }
            finally {
                this.reentrant = false;
            }
        }

        @Override
        public void println(Object x) {
            if (this.reentrant) {
                return;
            }
            this.reentrant = true;
            try {
                this.ps.println(x);
            }
            finally {
                this.reentrant = false;
            }
        }

        @Override
        public void println(String x) {
            if (this.reentrant) {
                return;
            }
            this.reentrant = true;
            try {
                this.ps.println(x);
            }
            finally {
                this.reentrant = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buf, int off, int len) {
            if (this.reentrant) {
                return;
            }
            this.reentrant = true;
            try {
                this.ps.write(buf, off, len);
            }
            finally {
                this.reentrant = false;
            }
        }

        @Override
        public void write(int b) {
            if (this.reentrant) {
                return;
            }
            this.reentrant = true;
            try {
                this.ps.write(b);
            }
            finally {
                this.reentrant = false;
            }
        }
    }
}

