/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator.trusted;

import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.locator.DelegatingLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.trusted.MemoryTrustedLocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class TrustedLocatorFactory
extends DelegatingLocatorFactory {
    private IDigester digester;

    public TrustedLocatorFactory(ILocatorFactory wrapped) {
        super(wrapped);
    }

    @Override
    protected ILocator basicCreateLocator(String location) throws IOException {
        ILocator locator = super.basicCreateLocator(location);
        return new MemoryTrustedLocator(this, locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized IDigest createDigest(InputStream is) throws IOException {
        try {
            this.init();
            this.digester.reset();
            IDigest iDigest = DigestTools.digest(this.digester, is);
            return iDigest;
        }
        catch (FileNotFoundException e) {
            IDigest iDigest = null;
            return iDigest;
        }
        finally {
            StreamTools.close(is);
        }
    }

    public synchronized IDigester getDigester() {
        this.init();
        return this.digester;
    }

    protected synchronized void init() {
        if (this.digester == null) {
            this.digester = DigestTools.createDigesterSHA1();
        }
    }

    public synchronized void setDigester(IDigester digester) {
        this.digester = digester;
    }
}

