/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.content.ICharsetAccess;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.locking.ILock;
import de.intarsys.tools.locking.ILockLevel;
import de.intarsys.tools.locking.ILockSupport;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.stream.TempFileOutputStream;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLocator
extends CommonLocator
implements ILockSupport,
ICharsetAccess {
    private static final Logger Log = LoggerFactory.getLogger(FileLocator.class);
    private final boolean append;
    private File canonicalFile;
    private String charset;
    private File file;
    private volatile long lastModified;
    private boolean outOfSynch;
    private boolean synchSynchronous;
    private boolean useTempFile;

    private static File createFile(String fileNameOrUri) {
        try {
            return new File(new URI(fileNameOrUri));
        }
        catch (IllegalArgumentException | URISyntaxException exception) {
            return new File(fileNameOrUri);
        }
    }

    public FileLocator(File file) {
        this.file = file;
        this.append = false;
    }

    public FileLocator(File file, boolean append) {
        this.file = file;
        this.append = append;
    }

    public FileLocator(String fileNameOrUri) {
        this(FileLocator.createFile(fileNameOrUri));
    }

    @Override
    public void delete() throws IOException {
        FileTools.deleteRecursivly(this.getFile());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileLocator)) {
            return false;
        }
        return this.getCanonicalFile().equals(((FileLocator)obj).getCanonicalFile());
    }

    @Override
    public boolean exists() {
        return this.getFile().exists();
    }

    public File getCanonicalFile() {
        if (this.canonicalFile == null) {
            try {
                this.canonicalFile = this.getFile().getCanonicalFile();
            }
            catch (IOException e) {
                this.canonicalFile = this.getFile();
            }
        }
        return this.canonicalFile;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public ILocator getChild(String name) {
        File childfile = new File(this.getFile(), name);
        FileLocator result = new FileLocator(childfile);
        result.setSynchSynchronous(this.isSynchSynchronous());
        return result;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.getLastModified();
        return new FileInputStream(this.getFile());
    }

    protected long getLastModified() {
        if (this.lastModified == 0L && this.file.exists()) {
            this.lastModified = this.file.lastModified();
        }
        return this.lastModified;
    }

    @Override
    public long getLength() throws IOException {
        return this.file.length();
    }

    @Override
    public ILock getLock() {
        return new FileLocatorLock();
    }

    @Override
    public String getName() {
        if (this.getFile() == null) {
            return "unknown";
        }
        return this.getFile().getName();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.getLastModified();
        File parentFile = FileTools.getParentFile(this.getFile());
        FileTools.mkdirs(parentFile);
        if (this.isUseTempFile()) {
            return new TempFileOutputStream(this.getFile(), "tmp_", "." + LocatorTools.getExtension(this));
        }
        return new FileOutputStream(this.getFile(), this.isAppend());
    }

    @Override
    public ILocator getParent() {
        File parentFile = FileTools.getParentFile(this.getFile());
        if (parentFile == null) {
            return null;
        }
        FileLocator result = new FileLocator(parentFile);
        result.setSynchSynchronous(this.isSynchSynchronous());
        return result;
    }

    @Override
    public String getPath() {
        if (this.getFile() == null) {
            return "unknown";
        }
        return PathTools.toCanonicalSeparator(this.getFile().getAbsolutePath());
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        this.getLastModified();
        if (this.isUseTempFile()) {
            throw new UnsupportedOperationException("no random access to temp file");
        }
        return new de.intarsys.tools.randomaccess.RandomAccessFile(this.getFile());
    }

    @Override
    public Reader getReader() throws IOException {
        this.getLastModified();
        if (StringTools.isEmpty(this.getCharset())) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getCharset());
    }

    @Override
    public Reader getReader(String charset) throws IOException {
        this.getLastModified();
        if (StringTools.isEmpty(charset)) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), charset);
    }

    @Override
    public Writer getWriter() throws IOException {
        this.getLastModified();
        if (StringTools.isEmpty(this.getCharset())) {
            return new OutputStreamWriter(this.getOutputStream());
        }
        return new OutputStreamWriter(this.getOutputStream(), this.getCharset());
    }

    @Override
    public Writer getWriter(String charset) throws IOException {
        this.getLastModified();
        if (StringTools.isEmpty(charset)) {
            return this.getWriter();
        }
        return new OutputStreamWriter(this.getOutputStream(), charset);
    }

    public int hashCode() {
        return this.getCanonicalFile().hashCode();
    }

    public boolean isAppend() {
        return this.append;
    }

    @Override
    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    @Override
    public synchronized boolean isOutOfSynch() {
        if (this.isSynchSynchronous()) {
            this.synchCheck();
        }
        return this.outOfSynch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isReadOnly() {
        if (super.isReadOnly()) {
            return true;
        }
        IRandomAccess r = null;
        try {
            if (!this.getFile().exists()) {
                if (this.getFile().createNewFile()) {
                    if (!this.getFile().delete()) {
                        Log.warn("could not delete test file {}", (Object)this.getFile());
                    }
                    boolean bl = false;
                    StreamTools.close(r);
                    return bl;
                }
                boolean bl = true;
                StreamTools.close(r);
                return bl;
            }
            r = this.getRandomAccess();
            if (r == null || r.isReadOnly()) {
                boolean bl = true;
                StreamTools.close(r);
                return bl;
            }
            boolean bl = false;
            StreamTools.close(r);
            return bl;
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            StreamTools.close(r);
        }
    }

    public boolean isSynchSynchronous() {
        return this.synchSynchronous;
    }

    public boolean isUseTempFile() {
        return this.useTempFile;
    }

    @Override
    public ILocator[] listLocators(final ILocatorNameFilter filter) throws IOException {
        if (!this.getFile().exists()) {
            throw new FileNotFoundException(this.getFile().getName() + " not found");
        }
        if (!this.getFile().isDirectory()) {
            throw new IOException(this.getFile().getName() + " not a directory");
        }
        File[] candidates = filter == null ? this.getFile().listFiles() : this.getFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String current) {
                return filter.accept(FileLocator.this, current);
            }
        });
        if (candidates == null) {
            throw new IOException("error listing resources");
        }
        ILocator[] result = new ILocator[candidates.length];
        for (int i = 0; i < result.length; ++i) {
            FileLocator l = new FileLocator(candidates[i].getPath());
            l.setSynchSynchronous(this.isSynchSynchronous());
            l.setCharset(this.getCharset());
            result[i] = l;
        }
        return result;
    }

    @Override
    public void rename(String newName) throws IOException {
        if (this.getFile() == null) {
            return;
        }
        File newFile = new File(newName);
        if (!newFile.isAbsolute()) {
            File parent = FileTools.getParentFile(this.getFile());
            newFile = parent == null ? new File(newName) : new File(parent, newName);
        }
        FileTools.renameFile(this.getFile(), newFile);
        this.file = newFile;
        this.canonicalFile = null;
        this.lastModified = 0L;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setSynchSynchronous(boolean synchSynchronous) {
        this.synchSynchronous = synchSynchronous;
    }

    public void setUseTempFile(boolean useTempFile) {
        this.useTempFile = useTempFile;
    }

    @Override
    public synchronized void synch() {
        this.outOfSynch = false;
        this.lastModified = 0L;
        this.getLastModified();
    }

    protected synchronized void synchCheck() {
        this.outOfSynch = false;
        if (this.getFile() == null) {
            return;
        }
        if (this.getLastModified() != this.getFile().lastModified()) {
            Log.trace("'" + this.getPath() + "' out of synch!");
            this.outOfSynch = true;
        }
    }

    public String toString() {
        return this.getFile().toString();
    }

    @Override
    public URI toURI() {
        return this.getFile().toURI();
    }

    class FileLocatorLock
    implements ILock {
        private RandomAccessFile ra;

        FileLocatorLock() {
        }

        @Override
        public boolean acquire(Object owner, ILockLevel level) {
            try {
                this.ra = new RandomAccessFile(FileLocator.this.getFile(), "r");
                return true;
            }
            catch (FileNotFoundException e) {
                return false;
            }
        }

        @Override
        public void release(Object owner) {
            StreamTools.close(this.ra);
        }
    }
}

