/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.installresource;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.installresource.Install;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallZip
extends Install {
    private static final Logger Log = LoggerFactory.getLogger(InstallZip.class);

    public InstallZip(String path, String name, boolean platformDependent) {
        super(path, name, platformDependent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadEntry(File parent, ZipFile zipFile, ZipEntry entry) throws IOException, FileNotFoundException {
        InputStream is = null;
        FileOutputStream os = null;
        String entryName = entry.getName();
        File entryFile = new File(parent, entryName);
        if (entry.isDirectory()) {
            FileTools.mkdirs(entryFile);
            return;
        }
        File entryDir = entryFile.getParentFile();
        FileTools.mkdirs(entryDir);
        try {
            is = zipFile.getInputStream(entry);
            os = new FileOutputStream(entryFile);
            StreamTools.copy(is, os);
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close(is);
        StreamTools.close(os);
    }

    @Override
    protected File loadURL(URL url) throws IOException {
        File file = TempTools.createTempFile("file", this.getName());
        InstallZip.copy(url, file);
        InstallZip.deleteOnExit(file);
        File dir = TempTools.createTempDir("dir", this.getName());
        this.loadZip(file, dir);
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadZip(File zip, File parent) throws ZipException, IOException {
        Log.trace("{} loadZip {} from {}", new Object[]{this.getLogLabel(), zip, parent});
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(zip);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                this.loadEntry(parent, zipFile, entry);
            }
        }
    }
}

