/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.exception.TunnelingException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.proxy.IProxy;
import de.intarsys.tools.reflect.IClassLoaderSupport;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.system.SystemTools;

public class ElementProxy<T>
implements IElementConfigurable,
IContextSupport,
IProxy<T> {
    private IElement element;
    private T realized;
    private Class proxyClass;
    private String proxyClassAttribute;
    private Object context;

    public ElementProxy() {
        this.proxyClass = Object.class;
        this.proxyClassAttribute = "class";
    }

    public ElementProxy(Class pProxyClass, IElement pElement, String classAttribute, Object context) {
        this.element = pElement;
        this.proxyClass = pProxyClass;
        this.proxyClassAttribute = classAttribute;
        this.context = context;
        if (SystemTools.isDebug("eager")) {
            this.getRealized();
        }
    }

    protected Object basicGetRealized() {
        return this.realized;
    }

    @Override
    public void configure(IElement pElement) {
        this.element = pElement;
    }

    public ClassLoader getClassLoader() {
        if (this.getContext() instanceof IClassLoaderSupport) {
            return ((IClassLoaderSupport)this.getContext()).getClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    public Object getContext() {
        return this.context;
    }

    public IElement getElement() {
        return this.element;
    }

    public Class getProxyClass() {
        return this.proxyClass;
    }

    public String getProxyClassAttribute() {
        return this.proxyClassAttribute;
    }

    @Override
    public synchronized T getRealized() {
        if (this.realized == null) {
            try {
                this.realized = this.realize();
            }
            catch (ObjectCreationException e) {
                throw new TunnelingException(e);
            }
        }
        return this.realized;
    }

    protected T realize() throws ObjectCreationException {
        Object object = ElementTools.createObject(this.getElement(), this.getProxyClassAttribute(), this.getProxyClass(), this.getContext(), Args.create());
        return object;
    }

    @Override
    public void setContext(Object context) {
        this.context = context;
    }

    public void setProxyClass(Class proxyClass) {
        this.proxyClass = proxyClass;
    }

    public void setProxyClassAttribute(String proxyClassAttribute) {
        this.proxyClassAttribute = proxyClassAttribute;
    }
}

