/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.format;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ISO8601Format {
    private static final ISO8601Format INSTANCE = new ISO8601Format();
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public static final ISO8601Format getInstance() {
        return INSTANCE;
    }

    protected ISO8601Format() {
    }

    public String format(Date date) {
        String partial = this.format.format(date);
        partial = partial.replaceAll("\\+0000$", "Z");
        partial = partial.replaceAll("(\\d\\d)$", ":$1");
        return partial;
    }

    public Date parse(String aISO8601Date) throws ParseException {
        String dateString = aISO8601Date;
        dateString = dateString.replaceAll(":(\\d\\d)$", "$1");
        dateString = dateString.replace("Z", "+0000");
        return this.format.parse(dateString);
    }
}

