/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class ArchiveTools {
    private static final Map DUMP_DIRS = new HashMap();
    private static final NumberFormat THE_FORMAT = NumberFormat.getNumberInstance();

    public static String archive(File root, String relativePath, File file, int max, String sourceEncoding, String destinationEncoding, boolean deleteSource, boolean forceArchive) throws IOException {
        File archive;
        if (max == 0 || root == null) {
            return null;
        }
        String dirName = FileTools.resolvePath(root, relativePath).getAbsolutePath();
        if (!forceArchive && dirName.equals(file.getParentFile().getAbsolutePath())) {
            archive = file;
        } else {
            DumpDirectory d = DumpDirectory.get(dirName);
            archive = d.getDumpFile(file.getName(), max);
            if (deleteSource) {
                FileTools.renameFile(file, sourceEncoding, archive, destinationEncoding);
            } else {
                FileTools.copyFile(file, sourceEncoding, archive, destinationEncoding);
            }
        }
        try {
            archive.setLastModified(System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return archive.getAbsolutePath();
    }

    public static String archive(File root, String relativePath, String filename, InputStream is, int max) throws IOException {
        if (max == 0 || root == null) {
            return null;
        }
        File archive = ArchiveTools.createArchive(root, relativePath, filename, max);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(archive);
            StreamTools.copy(is, os);
        }
        catch (Exception e) {
            try {
                throw new IOException("archiving failed (" + e.getMessage() + ")");
            }
            catch (Throwable throwable) {
                StreamTools.close(os);
                throw throwable;
            }
        }
        StreamTools.close(os);
        return archive.getAbsolutePath();
    }

    public static File createArchive(File root, String relativePath, String filename, int max) throws IOException {
        if (max == 0 || root == null) {
            return null;
        }
        String dirName = FileTools.resolvePath(root, relativePath).getAbsolutePath();
        DumpDirectory d = DumpDirectory.get(dirName);
        File archive = d.getDumpFile(filename, max);
        return archive;
    }

    public static OutputStream createOutputStream(File root, String filename, int max) throws IOException {
        if (max == 0 || root == null) {
            return null;
        }
        DumpDirectory d = DumpDirectory.get(root);
        File archive = d.getDumpFile(filename, max);
        return new FileOutputStream(archive);
    }

    private ArchiveTools() {
    }

    static {
        THE_FORMAT.setMaximumFractionDigits(0);
        THE_FORMAT.setMinimumIntegerDigits(19);
        THE_FORMAT.setGroupingUsed(false);
    }

    static class DumpDirectory {
        File dir;
        int currentCount;
        int dirCount;
        long lastDump = System.currentTimeMillis();

        public static DumpDirectory get(File file) {
            return DumpDirectory.get(file.getAbsolutePath());
        }

        public static synchronized DumpDirectory get(String name) {
            return (DumpDirectory)DUMP_DIRS.computeIfAbsent(name, key -> {
                DumpDirectory dd = new DumpDirectory(new File(name));
                dd.prepare();
                return dd;
            });
        }

        protected DumpDirectory(File dir) {
            this.setDir(dir);
        }

        protected void checkDir() throws IOException {
            FileTools.mkdirs(this.getDir());
        }

        protected void checkFiles(int max) throws IOException {
            if (max <= 0 || this.currentCount <= max) {
                return;
            }
            Object[] fileNames = this.dir.list();
            if (fileNames == null) {
                throw new IOException("can not list directory " + this.dir.getAbsolutePath());
            }
            if (fileNames.length != this.dirCount + this.currentCount) {
                this.prepare((String[])fileNames);
            }
            Arrays.sort(fileNames);
            int delete = Math.min(fileNames.length, this.currentCount - max);
            for (int i = 0; i < delete; ++i) {
                File deleteFile = new File(this.dir, (String)fileNames[i]);
                if (!deleteFile.isFile()) continue;
                Files.delete(deleteFile.toPath());
                --this.currentCount;
            }
        }

        public File getDir() {
            return this.dir;
        }

        public synchronized File getDumpFile(String name, int max) throws IOException {
            File newFile = new File(this.getDir(), this.getUniquePrefix() + "." + name);
            this.checkDir();
            if (!newFile.createNewFile()) {
                throw new IOException("can not create file " + newFile.getAbsolutePath());
            }
            ++this.currentCount;
            try {
                this.checkFiles(max);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return newFile;
        }

        public long getLastDump() {
            return this.lastDump;
        }

        protected long getUniqueMillis() {
            long current;
            for (current = System.currentTimeMillis(); this.getLastDump() >= current; ++current) {
            }
            this.setLastDump(current);
            return current;
        }

        protected String getUniquePrefix() {
            return THE_FORMAT.format(this.getUniqueMillis());
        }

        protected void prepare() {
            String[] fileNames = this.dir.list();
            if (fileNames == null) {
                return;
            }
            this.prepare(fileNames);
        }

        protected void prepare(String[] fileNames) {
            this.currentCount = 0;
            this.dirCount = 0;
            if (fileNames != null) {
                for (int i = 0; i < fileNames.length; ++i) {
                    File f = new File(this.dir, fileNames[i]);
                    if (f.isFile()) {
                        ++this.currentCount;
                        continue;
                    }
                    ++this.dirCount;
                }
            }
        }

        private void setDir(File newDir) {
            this.dir = newDir;
        }

        private void setLastDump(long newLastDump) {
            this.lastDump = newLastDump;
        }
    }
}

