/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Map;
import java.util.function.Supplier;

public class InstanceSpec<R> {
    public static final InstanceSpec<Object> EMPTY_SPEC = new InstanceSpec(Object.class, null, (IArgs)Args.create()){

        @Override
        public IArgs getArgs() {
            return Args.create();
        }
    };
    protected static final String META_ENABLED = "enabled";
    public static final String ARG_ARGS = "args";
    public static final String ARG_META = "_meta";
    public static final String ARG_FACTORY = "factory";
    public static final String ARG_CLASS = "class";
    public static final String ARG_PROCESSOR = "processor";
    public static final String ARG_VALUE = "value";
    private static final Object UNDEFINED = new Object();
    private Object factory;
    private IFactory<R> realFactory;
    private final IArgs container;
    private final IArgs args;
    private IArgs metaArgs;
    private Object instance;
    private final Class<R> instanceClass;

    public static <R> InstanceSpec<R> createFromArgs(Class<R> clazz, Object argsDef) {
        IArgs args = ArgTools.toArgs(argsDef);
        if (args == null) {
            return null;
        }
        IArgs metaArgs = ArgTools.getArgs(args, ARG_META, null);
        Object value = ArgTools.getObject(args, ARG_VALUE, null);
        if (value == null) {
            Object myFactory = ArgTools.getObject(args, ARG_FACTORY, null);
            if (myFactory == null && (myFactory = ArgTools.getObject(args, ARG_PROCESSOR, null)) == null) {
                myFactory = ArgTools.getObject(args, ARG_CLASS, null);
            }
            myFactory = FactoryTools.cleanup(myFactory);
            IArgs myArgs = ArgTools.getArgs(args, ARG_ARGS, null);
            if (myFactory == null && myArgs == null) {
                return null;
            }
            return InstanceSpec.createFromFactory(clazz, args, myFactory, myArgs, metaArgs);
        }
        return InstanceSpec.createFromValue(clazz, args, value, metaArgs);
    }

    protected static <R> InstanceSpec<R> createFromFactory(Class<R> clazz, IArgs container, Object factoryDef, Object argsDef, IArgs metaArgs) {
        factoryDef = FactoryTools.cleanup(factoryDef);
        IArgs args = ArgTools.toArgs(argsDef);
        if (args == null) {
            args = Args.create();
        }
        InstanceSpec<R> result = new InstanceSpec<R>(clazz, container, factoryDef, args, UNDEFINED, metaArgs);
        return result;
    }

    public static <R> InstanceSpec<R> createFromFactory(Class<R> clazz, Object factoryDef, Object argsDef) {
        return InstanceSpec.createFromFactory(clazz, Args.create(), factoryDef, argsDef, null);
    }

    public static <R> InstanceSpec<R> createFromTemplate(InstanceSpec<R> template) {
        InstanceSpec<R> result = new InstanceSpec<R>(template.getInstanceClass(), Args.create(), template.getFactory(), template.getArgs().copy(), UNDEFINED, template.getMetaArgs() == null ? null : template.getMetaArgs().copy());
        return result;
    }

    protected static <R> InstanceSpec<R> createFromValue(Class<R> clazz, IArgs container, Object value, IArgs metaArgs) {
        InstanceSpec<R> result = new InstanceSpec<R>(clazz, container, null, Args.create(), value, metaArgs);
        return result;
    }

    public static <R> InstanceSpec<R> createFromValue(Class<R> clazz, Object value) {
        return InstanceSpec.createFromValue(clazz, Args.create(), value, null);
    }

    public static <R> InstanceSpec<R> createNew(Class<R> clazz) {
        return InstanceSpec.createFromFactory(clazz, Args.create(), null, Args.create(), null);
    }

    public static <R> InstanceSpec<R> get(IArgs args, String role, Class<R> clazz, InstanceSpec<R> defaultValue) {
        InstanceSpec<R> spec;
        Object myValue = ArgTools.getObject(args, role, null);
        if (myValue == null) {
            return defaultValue;
        }
        if (myValue instanceof IArgs) {
            spec = InstanceSpec.createFromArgs(clazz, (IArgs)myValue);
        } else if (myValue instanceof InstanceSpec) {
            spec = (InstanceSpec<R>)myValue;
        } else if (myValue instanceof String || myValue instanceof Class || myValue instanceof IFactory) {
            if (clazz != Object.class && clazz.isInstance(myValue)) {
                spec = InstanceSpec.createFromValue(clazz, myValue);
            } else {
                spec = InstanceSpec.createFromFactory(clazz, myValue, Args.create());
                InstanceSpec.put(args, role, spec);
            }
        } else {
            spec = InstanceSpec.createFromValue(clazz, myValue);
        }
        if (spec == null) {
            return defaultValue;
        }
        return spec;
    }

    public static <R> R getAsInstance(IArgs args, String name, Class<R> clazz) throws ObjectCreationException {
        return (R)InstanceSpec.getAsInstance(args, name, clazz, () -> null);
    }

    public static <R> R getAsInstance(IArgs args, String name, Class<R> clazz, Supplier<R> defaultSupplier) throws ObjectCreationException {
        InstanceSpec<R> spec = InstanceSpec.get(args, name, clazz, null);
        if (spec == null || spec.getFactory() == null && spec.isInstanceUndefined()) {
            return defaultSupplier == null ? null : (R)defaultSupplier.get();
        }
        return spec.createInstance();
    }

    public static <R> InstanceSpec<R> getOrCreate(IArgs args, String role, Class<R> clazz) {
        InstanceSpec<R> spec = InstanceSpec.get(args, role, clazz, null);
        if (spec == null) {
            spec = new InstanceSpec<R>(clazz, null, Args.create());
            args.put(role, (Object)spec.toArgs());
        }
        return spec;
    }

    public static boolean isInstanceSpec(IArgs args) {
        Object value = ArgTools.getObject(args, ARG_VALUE, null);
        if (value != null) {
            return true;
        }
        value = ArgTools.getObject(args, ARG_FACTORY, null);
        if (value != null) {
            return true;
        }
        value = ArgTools.getObject(args, ARG_PROCESSOR, null);
        if (value != null) {
            return true;
        }
        value = ArgTools.getObject(args, ARG_CLASS, null);
        return value != null;
    }

    public static IArgs put(IArgs args, String role, Object spec) {
        if (spec instanceof InstanceSpec) {
            args.put(role, (Object)((InstanceSpec)spec).toArgs());
        } else {
            args.put(role, spec);
        }
        return args;
    }

    public static <R> InstanceSpec<R> toInstanceSpec(Object value, Class<R> clazz) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            value = ArgTools.toArgs(value);
        }
        if (value instanceof IArgs) {
            return InstanceSpec.createFromArgs(clazz, (IArgs)value);
        }
        if (value instanceof InstanceSpec) {
            return (InstanceSpec)value;
        }
        if (value instanceof String || value instanceof Class || value instanceof IFactory) {
            if (clazz != Object.class && clazz.isInstance(value)) {
                return InstanceSpec.createFromValue(clazz, value);
            }
            return InstanceSpec.createFromFactory(clazz, value, Args.create());
        }
        return InstanceSpec.createFromValue(clazz, value);
    }

    protected InstanceSpec(Class<R> instanceClass, IArgs container, Object factory, IArgs args, Object instance, IArgs metaArgs) {
        this.instanceClass = instanceClass;
        this.container = container;
        this.factory = factory;
        this.args = args;
        this.instance = instance;
        this.metaArgs = metaArgs;
        this.putInto(container);
    }

    public InstanceSpec(Class<R> instanceClass, IFactory<R> factory, IArgs args) {
        this(instanceClass, Args.create(), factory, args, UNDEFINED, null);
    }

    public InstanceSpec(Class<R> instanceClass, Object instance) {
        this(instanceClass, Args.create(), null, Args.create(), instance, null);
    }

    protected InstanceSpec(InstanceSpec<R> template) {
        this.args = template.args == null ? null : template.args.copy();
        this.container = Args.create();
        this.factory = template.factory;
        this.instance = template.instance;
        this.instanceClass = template.instanceClass;
        this.metaArgs = template.metaArgs == null ? null : template.metaArgs.copy();
        this.realFactory = template.realFactory;
        this.putInto(this.container);
    }

    public InstanceSpec<R> copy() {
        return new InstanceSpec<R>(this);
    }

    protected IFactory<R> createFactory() throws ObjectCreationException {
        return FactoryTools.toFactory(this.getFactory());
    }

    public R createInstance() throws ObjectCreationException {
        Object result;
        if (this.instance != UNDEFINED) {
            result = this.instance;
        } else {
            if (this.getRealFactory() == null) {
                throw new ObjectCreationException("No factory");
            }
            result = this.getRealFactory().createInstance(this.getArgs());
        }
        if (this.instanceClass != null && result != null && !this.instanceClass.isInstance(result)) {
            throw new ObjectCreationException("not an instance of " + this.instanceClass);
        }
        return (R)result;
    }

    public IArgs getArgs() {
        return this.args;
    }

    protected IArgs getContainer() {
        return this.container;
    }

    public Object getFactory() {
        return this.factory;
    }

    protected R getInstance() {
        return (R)this.instance;
    }

    protected Class<R> getInstanceClass() {
        return this.instanceClass;
    }

    protected IArgs getMetaArgs() {
        return this.metaArgs;
    }

    public IFactory<R> getRealFactory() throws ObjectCreationException {
        if (this.realFactory == null) {
            this.realFactory = this.createFactory();
        }
        return this.realFactory;
    }

    public boolean isEnabled() {
        if (this.getMetaArgs() == null) {
            return true;
        }
        return ArgTools.getBoolStrict(this.getMetaArgs(), META_ENABLED, true);
    }

    public boolean isInstanceUndefined() {
        return this.instance == UNDEFINED;
    }

    public IArgs putInto(IArgs args) {
        if (this.isInstanceUndefined()) {
            args.put(ARG_FACTORY, this.getFactory());
            args.undefine(ARG_PROCESSOR);
            args.put(ARG_ARGS, (Object)this.getArgs());
            if (this.getMetaArgs() != null && ArgTools.hasDefinedBindings(this.getMetaArgs())) {
                args.put(ARG_META, (Object)this.getMetaArgs());
            } else {
                args.undefine(ARG_META);
            }
            args.undefine(ARG_VALUE);
        } else {
            args.undefine(ARG_FACTORY);
            args.undefine(ARG_PROCESSOR);
            args.undefine(ARG_ARGS);
            args.put(ARG_VALUE, this.getInstance());
        }
        return args;
    }

    public void setEnabled(boolean value) {
        if (value) {
            if (this.getMetaArgs() != null) {
                this.getMetaArgs().undefine(META_ENABLED);
                if (!ArgTools.hasDefinedBindings(this.getMetaArgs())) {
                    this.getContainer().undefine(ARG_META);
                }
            }
        } else {
            if (this.getMetaArgs() == null) {
                this.metaArgs = Args.create();
            }
            this.getMetaArgs().put(META_ENABLED, (Object)false);
            this.getContainer().put(ARG_META, (Object)this.getMetaArgs());
        }
    }

    public void setFactory(Object factory) {
        this.factory = factory;
        this.realFactory = null;
        this.instance = UNDEFINED;
        this.putInto(this.getContainer());
    }

    public void setInstance(Object instance) {
        this.factory = null;
        this.instance = instance;
        this.putInto(this.getContainer());
    }

    public IArgs toArgs() {
        return this.getContainer();
    }

    public String toString() {
        return this.toArgs().toString();
    }
}

