/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.facade;

import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.facade.FacadeFactory;
import de.intarsys.tools.facade.IFacade;
import de.intarsys.tools.facade.IFacadeFactory;
import java.util.ArrayList;
import java.util.List;

public class DelegatingFacadeFactory
extends FacadeFactory {
    private static final Object ATTR_FACADE = new Object();
    private List<IFacadeFactory> factories = new ArrayList<IFacadeFactory>();

    public void addFactory(IFacadeFactory factory) {
        this.factories.add(factory);
    }

    protected IFacade basicCreate(Object nativeObject) {
        for (IFacadeFactory factory : this.factories) {
            IFacade result = factory.createFacade(nativeObject);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public final IFacade createFacade(Object nativeObject) {
        if (nativeObject instanceof IAttributeSupport) {
            IAttributeSupport as = (IAttributeSupport)nativeObject;
            IFacade result = (IFacade)as.getAttribute(ATTR_FACADE);
            if (result == null && (result = this.basicCreate(nativeObject)) != null) {
                as.setAttribute(ATTR_FACADE, result);
            }
            return result;
        }
        if (nativeObject != null) {
            return this.basicCreate(nativeObject);
        }
        return null;
    }

    public void removeFactory(IFacadeFactory factory) {
        this.factories.remove(factory);
    }
}

