/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.NamespaceNotFound;
import de.intarsys.tools.expression.ScopedResolver;
import de.intarsys.tools.functor.IArgs;

public class ThreadContextAwareResolver
implements IStringEvaluator {
    private static final ThreadLocal<ScopedResolver> RESOLVER = new ThreadLocal();

    public static synchronized IStringEvaluator attach(IStringEvaluator pResolver) {
        ScopedResolver tempResolver = RESOLVER.get();
        if (tempResolver == null) {
            tempResolver = new ScopedResolver();
            RESOLVER.set(tempResolver);
        }
        tempResolver.pushResolver(pResolver);
        return pResolver;
    }

    public static synchronized MapResolver attachMapResolver() {
        return (MapResolver)ThreadContextAwareResolver.attach(MapResolver.createStrict());
    }

    public static synchronized void detach(IStringEvaluator pResolver) {
        ScopedResolver tempResolver = RESOLVER.get();
        if (tempResolver == null) {
            return;
        }
        tempResolver.removeResolver(pResolver);
        if (tempResolver.isEmpty()) {
            RESOLVER.remove();
        }
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        ScopedResolver tempResolver = RESOLVER.get();
        if (tempResolver == null) {
            throw new NamespaceNotFound("can't evaluate '" + expression + "'");
        }
        return tempResolver.evaluate(expression, args);
    }
}

