/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.system.SystemTools;

public class SystemResolver
implements IStringEvaluator {
    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        if (expression == null) {
            throw new EvaluationException("expression is null");
        }
        if ("architecture".equals(expression)) {
            String arch = SystemTools.getOSArch();
            return arch != null && arch.contains("64") ? "64-bit" : "32-bit";
        }
        int indexOfSeparator = expression.indexOf(46);
        if (indexOfSeparator >= 0) {
            String namespace = expression.substring(0, indexOfSeparator);
            String localExpression = expression.substring(indexOfSeparator + 1);
            if ("properties".equals(namespace)) {
                return System.getProperty(localExpression);
            }
            if ("getenv".equals(namespace)) {
                return System.getenv(localExpression);
            }
        }
        throw new EvaluationException(String.format("can't evaluate '%s'", expression));
    }
}

