/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.encoding;

import java.io.ByteArrayOutputStream;

public final class Base32 {
    private static final String BASE32CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final int[] BASE32LOOKUP = new int[]{255, 255, 26, 27, 28, 29, 30, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255};

    public static byte[] decode(String value) {
        char[] chars = value.toCharArray();
        int current = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(chars.length * 5 / 8);
        int index = 0;
        for (int i = 0; i < chars.length; ++i) {
            int digit;
            int lookup = chars[i] - 48;
            if (lookup < 0 || lookup >= BASE32LOOKUP.length || (digit = BASE32LOOKUP[lookup]) == 255) continue;
            if (index <= 3) {
                if ((index = (index + 5) % 8) == 0) {
                    bos.write(current |= digit);
                    current = 0;
                    continue;
                }
                current |= digit << 8 - index;
                continue;
            }
            index = (index + 5) % 8;
            bos.write(current |= digit >>> index);
            current = digit << 8 - index;
        }
        return bos.toByteArray();
    }

    public static String encode(byte[] bytes) {
        return Base32.encode(bytes, 0, bytes.length);
    }

    public static String encode(byte[] bytes, int offset, int len) {
        int index = 0;
        int digit = 0;
        int add = 0;
        switch (len) {
            case 1: {
                add = 6;
                break;
            }
            case 2: {
                add = 4;
                break;
            }
            case 3: {
                add = 3;
                break;
            }
            case 4: {
                add = 1;
                break;
            }
            default: {
                add = 0;
            }
        }
        StringBuilder base32 = new StringBuilder((len + 7) * 8 / 5 + add);
        int i = offset;
        int stop = offset + len;
        while (i < stop) {
            int currByte;
            int n = currByte = bytes[i] >= 0 ? bytes[i] : bytes[i] + 256;
            if (index > 3) {
                int nextByte = i + 1 < stop ? (bytes[i + 1] >= 0 ? bytes[i + 1] : bytes[i + 1] + 256) : 0;
                digit = currByte & 255 >> index;
                index = (index + 5) % 8;
                digit <<= index;
                digit |= nextByte >> 8 - index;
                ++i;
            } else {
                digit = currByte >> 8 - (index + 5) & 0x1F;
                if ((index = (index + 5) % 8) == 0) {
                    ++i;
                }
            }
            base32.append(BASE32CHARS.charAt(digit));
        }
        switch (len) {
            case 1: {
                base32.append("======");
                break;
            }
            case 2: {
                base32.append("====");
                break;
            }
            case 3: {
                base32.append("===");
                break;
            }
            case 4: {
                base32.append("=");
                break;
            }
        }
        return base32.toString();
    }

    private Base32() {
    }
}

