/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.converter;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.IConverter;
import java.awt.Color;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColorFromStringConverter
implements IConverter<String, Color> {
    private static final String COLOR_KEYWORD_NONE = "none";
    private static final Map<String, Integer> COLOR_KEYWORDS = Map.ofEntries(Map.entry("aliceblue", 0xF0F8FF), Map.entry("antiquewhite", 16444375), Map.entry("aqua", 65535), Map.entry("aquamarine", 8388564), Map.entry("azure", 0xF0FFFF), Map.entry("beige", 16119260), Map.entry("bisque", 16770244), Map.entry("black", 0), Map.entry("blanchedalmond", 16772045), Map.entry("blue", 255), Map.entry("blueviolet", 9055202), Map.entry("brown", 0xA52A2A), Map.entry("burlywood", 14596231), Map.entry("cadetblue", 6266528), Map.entry("chartreuse", 0x7FFF00), Map.entry("chocolate", 13789470), Map.entry("coral", 16744272), Map.entry("cornflowerblue", 6591981), Map.entry("cornsilk", 16775388), Map.entry("crimson", 14423100), Map.entry("cyan", 65535), Map.entry("darkblue", 139), Map.entry("darkcyan", 35723), Map.entry("darkgoldenrod", 12092939), Map.entry("darkgray", 0xA9A9A9), Map.entry("darkgreen", 25600), Map.entry("darkgrey", 0xA9A9A9), Map.entry("darkkhaki", 12433259), Map.entry("darkmagenta", 0x8B008B), Map.entry("darkolivegreen", 5597999), Map.entry("darkorange", 16747520), Map.entry("darkorchid", 10040012), Map.entry("darkred", 0x8B0000), Map.entry("darksalmon", 15308410), Map.entry("darkseagreen", 9419919), Map.entry("darkslateblue", 4734347), Map.entry("darkslategray", 0x2F4F4F), Map.entry("darkslategrey", 0x2F4F4F), Map.entry("darkturquoise", 52945), Map.entry("darkviolet", 9699539), Map.entry("deeppink", 16716947), Map.entry("deepskyblue", 49151), Map.entry("dimgray", 0x696969), Map.entry("dimgrey", 0x696969), Map.entry("dodgerblue", 2003199), Map.entry("firebrick", 0xB22222), Map.entry("floralwhite", 0xFFFAF0), Map.entry("forestgreen", 0x228B22), Map.entry("fuchsia", 0xFF00FF), Map.entry("gainsboro", 0xDCDCDC), Map.entry("ghostwhite", 0xF8F8FF), Map.entry("gold", 16766720), Map.entry("goldenrod", 14329120), Map.entry("gray", 0x808080), Map.entry("green", 32768), Map.entry("greenyellow", 11403055), Map.entry("grey", 0x808080), Map.entry("honeydew", 0xF0FFF0), Map.entry("hotpink", 16738740), Map.entry("indianred", 0xCD5C5C), Map.entry("indigo", 4915330), Map.entry("ivory", 0xFFFFF0), Map.entry("khaki", 15787660), Map.entry("lavender", 15132410), Map.entry("lavenderblush", 0xFFF0F5), Map.entry("lawngreen", 8190976), Map.entry("lemonchiffon", 16775885), Map.entry("lightblue", 11393254), Map.entry("lightcoral", 0xF08080), Map.entry("lightcyan", 0xE0FFFF), Map.entry("lightgoldenrodyellow", 16448210), Map.entry("lightgray", 0xD3D3D3), Map.entry("lightgreen", 0x90EE90), Map.entry("lightgrey", 0xD3D3D3), Map.entry("lightpink", 16758465), Map.entry("lightsalmon", 16752762), Map.entry("lightseagreen", 2142890), Map.entry("lightskyblue", 8900346), Map.entry("lightslategray", 0x778899), Map.entry("lightslategrey", 0x778899), Map.entry("lightsteelblue", 11584734), Map.entry("lightyellow", 0xFFFFE0), Map.entry("lime", 65280), Map.entry("limegreen", 3329330), Map.entry("linen", 16445670), Map.entry("magenta", 0xFF00FF), Map.entry("maroon", 0x800000), Map.entry("mediumaquamarine", 6737322), Map.entry("mediumblue", 205), Map.entry("mediumorchid", 12211667), Map.entry("mediumpurple", 9662683), Map.entry("mediumseagreen", 3978097), Map.entry("mediumslateblue", 8087790), Map.entry("mediumspringgreen", 64154), Map.entry("mediumturquoise", 4772300), Map.entry("mediumvioletred", 13047173), Map.entry("midnightblue", 1644912), Map.entry("mintcream", 0xF5FFFA), Map.entry("mistyrose", 16770273), Map.entry("moccasin", 16770229), Map.entry("navajowhite", 16768685), Map.entry("navy", 128), Map.entry("oldlace", 16643558), Map.entry("olive", 0x808000), Map.entry("olivedrab", 7048739), Map.entry("orange", 16753920), Map.entry("orangered", 16729344), Map.entry("orchid", 14315734), Map.entry("palegoldenrod", 0xEEE8AA), Map.entry("palegreen", 10025880), Map.entry("paleturquoise", 0xAFEEEE), Map.entry("palevioletred", 14381203), Map.entry("papayawhip", 16773077), Map.entry("peachpuff", 16767673), Map.entry("peru", 13468991), Map.entry("pink", 16761035), Map.entry("plum", 0xDDA0DD), Map.entry("powderblue", 11591910), Map.entry("purple", 0x800080), Map.entry("red", 0xFF0000), Map.entry("rosybrown", 12357519), Map.entry("royalblue", 4286945), Map.entry("saddlebrown", 9127187), Map.entry("salmon", 16416882), Map.entry("sandybrown", 16032864), Map.entry("seagreen", 3050327), Map.entry("seashell", 0xFFF5EE), Map.entry("sienna", 10506797), Map.entry("silver", 0xC0C0C0), Map.entry("skyblue", 8900331), Map.entry("slateblue", 6970061), Map.entry("slategray", 7372944), Map.entry("slategrey", 7372944), Map.entry("snow", 0xFFFAFA), Map.entry("springgreen", 65407), Map.entry("steelblue", 4620980), Map.entry("tan", 13808780), Map.entry("teal", 32896), Map.entry("thistle", 14204888), Map.entry("tomato", 16737095), Map.entry("turquoise", 4251856), Map.entry("violet", 0xEE82EE), Map.entry("wheat", 16113331), Map.entry("white", 0xFFFFFF), Map.entry("whitesmoke", 0xF5F5F5), Map.entry("yellow", 0xFFFF00), Map.entry("yellowgreen", 10145074));
    private static final Pattern PATTERN_RGB = Pattern.compile("rgb\\((.*?),(.*?),(.*?)\\)", 2);
    private static final Pattern PATTERN_RGBA = Pattern.compile("rgba\\((.*?),(.*?),(.*?),(.*?)\\)", 2);

    @Override
    public Color convert(String source) throws ConversionException {
        String keywordOrHex = source.trim().toLowerCase();
        if (COLOR_KEYWORD_NONE.equals(keywordOrHex)) {
            return null;
        }
        if (COLOR_KEYWORDS.containsKey(keywordOrHex)) {
            return new Color(COLOR_KEYWORDS.get(keywordOrHex));
        }
        Matcher matcher = PATTERN_RGB.matcher(keywordOrHex);
        if (matcher.matches()) {
            return new Color(Integer.valueOf(matcher.group(1).trim()), Integer.valueOf(matcher.group(2).trim()), Integer.valueOf(matcher.group(3).trim()));
        }
        matcher = PATTERN_RGBA.matcher(keywordOrHex);
        if (matcher.matches()) {
            return new Color((float)Integer.valueOf(matcher.group(1).trim()).intValue() / 255.0f, (float)Integer.valueOf(matcher.group(2).trim()).intValue() / 255.0f, (float)Integer.valueOf(matcher.group(3).trim()).intValue() / 255.0f, Float.valueOf(matcher.group(4).trim()).floatValue());
        }
        if (keywordOrHex.charAt(0) == '#') {
            keywordOrHex = source.substring(1);
        }
        try {
            return Color.decode(keywordOrHex);
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public Class<String> getSourceType() {
        return String.class;
    }

    @Override
    public Class<Color> getTargetType() {
        return Color.class;
    }
}

