/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import de.intarsys.tools.concurrent.ITaskListener;
import de.intarsys.tools.concurrent.TaskFailed;

public class TaskCallbackAdapter<R>
implements ITaskListener<R> {
    @Override
    public final void failed(TaskFailed exception) {
        try {
            if (exception.isCancellation()) {
                this.onFailedCancellation(exception);
            } else {
                this.onFailedException(exception);
            }
            this.onFailed(exception);
        }
        finally {
            this.onFinally();
        }
    }

    @Override
    public final void finished(R result) {
        try {
            this.onFinished(result);
        }
        finally {
            this.onFinally();
        }
    }

    protected void onFailed(TaskFailed exception) {
    }

    protected void onFailedCancellation(TaskFailed exception) {
    }

    protected void onFailedException(TaskFailed exception) {
    }

    protected void onFinally() {
    }

    protected void onFinished(R result) {
    }

    @Override
    public void started() {
    }
}

