/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.servicelocator.ServiceLocator;
import jakarta.annotation.PreDestroy;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;

@SingletonProvider
public class ExecutorEnvironment {
    private ExecutorService service;

    public static ExecutorEnvironment get() {
        return ServiceLocator.get().get(ExecutorEnvironment.class);
    }

    private static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        LinkedBlockingQueue workQueue = new LinkedBlockingQueue();
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)workQueue, threadFactory){

            @Override
            public void execute(Runnable command) {
                Map contextMap = MDC.getCopyOfContextMap();
                super.execute(() -> {
                    Map previousContextMap = MDC.getCopyOfContextMap();
                    if (contextMap == null) {
                        MDC.clear();
                    } else {
                        MDC.setContextMap((Map)contextMap);
                    }
                    try {
                        command.run();
                    }
                    finally {
                        if (previousContextMap == null) {
                            MDC.clear();
                        } else {
                            MDC.setContextMap((Map)previousContextMap);
                        }
                    }
                });
            }
        };
    }

    protected ExecutorService createService() {
        return ExecutorEnvironment.newFixedThreadPool(1, ThreadTools.newThreadFactoryDaemon("ExecutorEnvironment service"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void destroy() {
        ExecutorService tmpService;
        ExecutorEnvironment executorEnvironment = this;
        synchronized (executorEnvironment) {
            tmpService = this.service;
            this.service = null;
        }
        if (tmpService != null) {
            tmpService.shutdownNow();
        }
    }

    public synchronized ExecutorService getService() {
        if (this.service == null) {
            this.service = this.createService();
        }
        return this.service;
    }

    public synchronized void setService(ExecutorService service) {
        this.service = service;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("ExecutorEnvironment shutdown"){

            @Override
            public void run() {
                ExecutorEnvironment.get().destroy();
            }
        });
    }
}

