/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.component;

import de.intarsys.tools.component.IExpirationSupport;
import de.intarsys.tools.concurrent.ThreadTools;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpirationWatchdog {
    private static final Logger Log = LoggerFactory.getLogger(ExpirationWatchdog.class);
    private final Object lock = new Object();
    private final IResourceHolder owner;
    private ScheduledExecutorService cleanupExecutor;
    private long cleanupInterval = 60000L;

    public ExpirationWatchdog(IResourceHolder owner) {
        this.owner = owner;
    }

    protected void cleanup() {
        try {
            Log.debug("expiration watchdog cleanup");
            List<IExpirationSupport> tempResources = this.getOwner().getResources();
            for (IExpirationSupport resource : tempResources) {
                if (!resource.isExpired()) continue;
                Log.debug("expiration watchdog expire {}", (Object)resource);
                try {
                    this.getOwner().expire(resource);
                }
                catch (Throwable e) {
                    Log.warn("expiration watchdog cleanup failed", e);
                }
            }
            this.wake();
        }
        catch (Throwable e) {
            Log.warn("expiration watchdog cleanup failed", e);
        }
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public IResourceHolder getOwner() {
        return this.owner;
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
        if (this.cleanupExecutor != null) {
            this.stop();
            this.start();
        }
    }

    protected void start() {
        if (this.cleanupExecutor != null) {
            return;
        }
        this.cleanupExecutor = Executors.newSingleThreadScheduledExecutor(ThreadTools.newThreadFactoryDaemon("session registry reaper"));
        this.cleanupExecutor.scheduleWithFixedDelay(this::cleanup, this.getCleanupInterval(), this.getCleanupInterval(), TimeUnit.MILLISECONDS);
    }

    protected void stop() {
        if (this.cleanupExecutor == null) {
            return;
        }
        this.cleanupExecutor.shutdown();
        this.cleanupExecutor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Object object = this.lock;
        synchronized (object) {
            if (this.getOwner().getResourceCount() == 0) {
                this.stop();
            } else {
                this.start();
            }
        }
    }

    public static interface IResourceHolder {
        public void expire(IExpirationSupport var1);

        public int getResourceCount();

        public List<IExpirationSupport> getResources();
    }
}

