/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class FilterIterator<T>
implements Iterator<T> {
    private static final Object UNDEFINED = new Object();
    private Iterator<T> baseIterator;
    private Object nextElement = UNDEFINED;

    protected FilterIterator(Iterator<T> baseIterator) {
        this.baseIterator = baseIterator;
    }

    protected abstract boolean accept(T var1);

    public Iterator<T> getBaseIterator() {
        return this.baseIterator;
    }

    @Override
    public boolean hasNext() {
        while (this.nextElement == UNDEFINED && this.baseIterator.hasNext()) {
            T nextCandidate = this.baseIterator.next();
            if (!this.accept(nextCandidate)) continue;
            this.nextElement = nextCandidate;
        }
        return this.nextElement != UNDEFINED;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object result = this.nextElement;
        this.nextElement = UNDEFINED;
        return (T)result;
    }

    @Override
    public void remove() {
        this.baseIterator.remove();
    }
}

