/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.attachment;

import de.intarsys.tools.attachment.Attachment;
import de.intarsys.tools.concurrent.ForwardedThreadLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class AttachmentTools {
    private static final List<Attachment> EMPTY = Collections.emptyList();
    private static final ThreadLocal<AttachmentList> THREADATTACHMENTS = new ForwardedThreadLocal<AttachmentList>();

    public static void addAttachment(Attachment attachment) {
        if (attachment == null) {
            return;
        }
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return;
        }
        temp.list.add(attachment);
    }

    public static void addAttachment(String key, Object value) {
        AttachmentTools.addAttachment(new Attachment(key, value));
    }

    public static void addAttachments(List<Attachment> pAttachments) {
        if (pAttachments == null) {
            return;
        }
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return;
        }
        temp.list.addAll(pAttachments);
    }

    public static void attach() {
        AttachmentList temp = THREADATTACHMENTS.get();
        if (temp == null) {
            temp = new AttachmentList();
            THREADATTACHMENTS.set(temp);
        } else {
            ++temp.counter;
        }
    }

    protected static AttachmentList basicGetAttachments() {
        return THREADATTACHMENTS.get();
    }

    public static void clearAttachments() {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return;
        }
        temp.list.clear();
    }

    public static void detach() {
        AttachmentList temp = THREADATTACHMENTS.get();
        if (temp == null) {
            return;
        }
        if (temp.counter <= 0) {
            temp.list.clear();
            THREADATTACHMENTS.remove();
        }
        --temp.counter;
    }

    public static Attachment getAttachment(String key) {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return null;
        }
        for (Attachment attachment : temp.list) {
            if (!key.equals(attachment.getKey())) continue;
            return attachment;
        }
        return null;
    }

    public static List<Attachment> getAttachments() {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return EMPTY;
        }
        return new ArrayList<Attachment>(temp.list);
    }

    public static List<Attachment> getAttachments(String key) {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return EMPTY;
        }
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (Attachment attachment : temp.list) {
            if (!key.equals(attachment.getKey())) continue;
            result.add(attachment);
        }
        return result;
    }

    public static boolean hasAttachment(String key) {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return false;
        }
        for (Attachment attachment : temp.list) {
            if (!key.equals(attachment.getKey())) continue;
            return true;
        }
        return false;
    }

    public static boolean removeAttached(Object attached) {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return false;
        }
        Iterator<Attachment> it = temp.list.iterator();
        while (it.hasNext()) {
            Attachment attachment = it.next();
            if (attachment.getAttached() != attached) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public static boolean removeAttachment(Attachment pAttachment) {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return false;
        }
        Iterator<Attachment> it = temp.list.iterator();
        while (it.hasNext()) {
            Attachment attachment = it.next();
            if (attachment != pAttachment) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public static void removeAttachments(String key) {
        AttachmentList temp = AttachmentTools.basicGetAttachments();
        if (temp == null) {
            return;
        }
        Iterator<Attachment> it = temp.list.iterator();
        while (it.hasNext()) {
            Attachment attachment = it.next();
            if (!key.equals(attachment.getKey())) continue;
            it.remove();
        }
    }

    private AttachmentTools() {
    }

    static class AttachmentList {
        protected List<Attachment> list = new ArrayList<Attachment>();
        protected int counter;

        AttachmentList() {
        }
    }
}

