/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.servlet.filter;

import de.intarsys.tools.servlet.common.ServletTools;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.slf4j.MDC;

public class CallContextFilter
implements Filter {
    private static final String MDC_CLIENT = "client";
    private static final String MDC_USER = "user";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        MDC.put((String)MDC_USER, (String)this.getUser(httpRequest));
        MDC.put((String)MDC_CLIENT, (String)this.getIp(httpRequest));
        try {
            chain.doFilter(request, response);
        }
        finally {
            MDC.remove((String)MDC_USER);
            MDC.remove((String)MDC_CLIENT);
        }
    }

    protected String getIp(HttpServletRequest request) {
        return ServletTools.getClientIp(request);
    }

    protected String getUser(HttpServletRequest request) {
        return ServletTools.getUser(request);
    }
}

