/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.servlet.filter;

import de.intarsys.tools.exception.ExceptionTools;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogFilter
implements Filter {
    private static final Logger Log = LoggerFactory.getLogger(AccessLogFilter.class);

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            Log.debug(">>> {} {}", (Object)httpRequest.getMethod(), (Object)httpRequest.getRequestURI());
            chain.doFilter(request, (ServletResponse)httpResponse);
            Log.debug("<<< {}", (Object)httpResponse.getStatus());
        }
        catch (ServletException | IOException | RuntimeException e) {
            Log.debug("<<< exception {}", (Object)ExceptionTools.getMessageShort((Throwable)e));
            throw e;
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

