/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.servlet.common;

import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.concurrent.ForwardedThreadLocal;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.annotation.WebListener;
import jakarta.servlet.http.HttpServletRequest;

@Singleton
@WebListener
public class WebContext
implements ServletContextListener,
ServletRequestListener {
    private static ServletContext ServletContext;
    private static final ThreadLocal<HttpServletRequest> REQUEST;

    public static HttpServletRequest getRequest() {
        return REQUEST.get();
    }

    public static ServletContext getServletContext() {
        return ServletContext;
    }

    public static void removeRequest() {
        REQUEST.remove();
    }

    public static void setRequest(HttpServletRequest tmpRequest) {
        REQUEST.set(tmpRequest);
    }

    public static void setServletContext(ServletContext servletContext) {
        ServletContext = servletContext;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        WebContext.setServletContext(null);
    }

    public void contextInitialized(ServletContextEvent sce) {
        WebContext.setServletContext(sce.getServletContext());
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        WebContext.removeRequest();
    }

    public void requestInitialized(ServletRequestEvent sre) {
        HttpServletRequest tmpRequest = (HttpServletRequest)sre.getServletRequest();
        WebContext.setRequest(tmpRequest);
    }

    static {
        REQUEST = new ForwardedThreadLocal();
    }
}

