/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.st.COSObjectStream;
import de.intarsys.pdf.st.IXRefEntryVisitor;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.XRefEntryVisitorException;
import java.io.IOException;

public class STXRefEntryCompressed
extends STXRefEntry {
    private final int streamObjectNumber;
    private final short streamGenerationNumber;
    private int index;

    public STXRefEntryCompressed(int objectNumber, int generationNumber, int streamObjectNumber, int streamGenerationNumber, int indexOfObject) {
        super(objectNumber, generationNumber);
        this.streamObjectNumber = streamObjectNumber;
        this.streamGenerationNumber = (short)streamGenerationNumber;
        this.index = indexOfObject;
    }

    @Override
    public void accept(IXRefEntryVisitor visitor) throws XRefEntryVisitorException {
        visitor.visitFromCompressed(this);
    }

    @Override
    public STXRefEntry copy() {
        return new STXRefEntryCompressed(this.getObjectNumber(), this.getGenerationNumber(), this.getStreamObjectNumber(), this.getStreamGenerationNumber(), this.getIndex());
    }

    @Override
    public STXRefEntryOccupied fill(long pos) {
        return null;
    }

    @Override
    public long getColumn1() {
        return 0L;
    }

    @Override
    public int getColumn2() {
        return 0;
    }

    public int getIndex() {
        return this.index;
    }

    public int getStreamGenerationNumber() {
        return this.streamGenerationNumber & 0xFFFF;
    }

    public int getStreamObjectNumber() {
        return this.streamObjectNumber;
    }

    @Override
    public boolean isFree() {
        return false;
    }

    @Override
    public COSObject load(STDocument doc, ISystemSecurityHandler securityHandler) throws IOException, COSLoadException {
        COSIndirectObject streamObjectRef = doc.getObjectReference(this.getStreamObjectNumber(), this.getStreamGenerationNumber());
        COSObject objStrmIO = streamObjectRef.dereference();
        if (objStrmIO != null && !objStrmIO.isNull()) {
            COSObjectStream strm = (COSObjectStream)COSObjectStream.META.createFromCos(objStrmIO);
            return strm.loadObject(this.index, doc.getParser());
        }
        return null;
    }

    @Override
    protected void unlink() {
    }
}

