/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.font.IdentityCMap;
import de.intarsys.pdf.font.InternalCMap;
import de.intarsys.pdf.font.NamedCMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class CMap
extends COSBasedObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());

    public static int toInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < bytes.length; ++i) {
            result = (result << 8) + (bytes[i] & 0xFF);
        }
        return result;
    }

    public static int toInt(byte[] bytes, int offset, int length) {
        int result = 0;
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            result = (result << 8) + (bytes[i] & 0xFF);
        }
        return result;
    }

    protected CMap(COSObject object) {
        super(object);
    }

    public abstract char[] getChars(int var1);

    public abstract int getDecoded(int var1);

    public abstract int getEncoded(int var1);

    public abstract int getNextDecoded(InputStream var1) throws IOException;

    public abstract int getNextEncoded(InputStream var1) throws IOException;

    public abstract void putNextDecoded(OutputStream var1, int var2) throws IOException;

    public abstract void putNextEncoded(OutputStream var1, int var2) throws IOException;

    public static class MetaClass
    extends COSBasedObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            if (object instanceof COSName) {
                CMap result = null;
                result = IdentityCMap.getSingleton((COSName)object);
                if (result == null) {
                    result = NamedCMap.loadCMap((COSName)object);
                }
                if (result == null) {
                    result = IdentityCMap.SINGLETON;
                }
                return result;
            }
            if (object instanceof COSStream) {
                return new InternalCMap(object);
            }
            throw new IllegalArgumentException("CMap must be defined using COSStream or COSName");
        }
    }
}

