/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.StandardCryptHandler;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESCryptHandler
extends StandardCryptHandler {
    public static final String KEY_ALGORITHM = "AES";
    public static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final String DIGEST_ALGORITHM = "MD5";
    private int blockSize;

    @Override
    protected synchronized byte[] basicDecrypt(byte[] data, byte[] encryptionKey, int objectNum, int genNum) throws COSSecurityException {
        try {
            this.updateHash(encryptionKey, objectNum, genNum);
            byte[] keyBase = this.md.digest();
            IvParameterSpec ivSpec = new IvParameterSpec(data, 0, this.blockSize);
            SecretKeySpec skeySpec = new SecretKeySpec(keyBase, 0, this.length, KEY_ALGORITHM);
            this.cipher.init(2, (Key)skeySpec, ivSpec);
            return this.cipher.doFinal(data, this.blockSize, data.length - this.blockSize);
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    @Override
    protected synchronized byte[] basicEncrypt(byte[] data, byte[] encryptionKey, int objectNum, int genNum) throws COSSecurityException {
        try {
            this.updateHash(encryptionKey, objectNum, genNum);
            byte[] keyBase = this.md.digest();
            byte[] initVector = this.cipher.getIV();
            if (initVector == null) {
                initVector = new byte[16];
            }
            IvParameterSpec ivSpec = new IvParameterSpec(initVector, 0, initVector.length);
            SecretKeySpec skeySpec = new SecretKeySpec(keyBase, 0, this.length, KEY_ALGORITHM);
            this.cipher.init(1, (Key)skeySpec, ivSpec);
            byte[] encrypted = this.cipher.doFinal(data, 0, data.length);
            byte[] result = new byte[initVector.length + encrypted.length];
            System.arraycopy(initVector, 0, result, 0, initVector.length);
            System.arraycopy(encrypted, 0, result, initVector.length, encrypted.length);
            return result;
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    @Override
    public void initialize(byte[] pCryptKey) throws COSSecurityException {
        super.initialize(pCryptKey);
        try {
            this.md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            this.cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            this.blockSize = this.cipher.getBlockSize();
        }
        catch (NoSuchAlgorithmException e) {
            throw new COSSecurityException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new COSSecurityException(e);
        }
    }

    @Override
    protected void updateHash(byte[] encryptionKey, int objectNum, int genNum) {
        super.updateHash(encryptionKey, objectNum, genNum);
        this.md.update(new byte[]{115, 65, 108, 84});
    }
}

