/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.xmp;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.jempbox.xmp.XMPMetadata;
import org.jempbox.xmp.XMPSchema;
import org.jempbox.xmp.pdfa.XMPSchemaPDFAExtension;
import org.jempbox.xmp.pdfa.XMPSchemaPDFAId;
import org.w3c.dom.Document;

public class GenericXMPMetadata
extends XMPMetadata {
    public static Builder empty() {
        return new Builder();
    }

    public static Builder from(Document document) {
        return new Builder().withDocument(document);
    }

    public GenericXMPMetadata(Map<String, Class<? extends XMPSchema>> schemaTypesByNamespaceUri) throws IOException {
        this.nsMappings.putAll(schemaTypesByNamespaceUri);
    }

    public GenericXMPMetadata(Map<String, Class<? extends XMPSchema>> schemaTypesByNamespaceUri, Document document) {
        super(document);
        this.nsMappings.putAll(schemaTypesByNamespaceUri);
    }

    public <S extends XMPSchema> S getSchema(Class<S> type) throws IOException {
        for (XMPSchema candidate : this.getSchemas()) {
            if (!type.isInstance(candidate)) continue;
            return (S)((XMPSchema)type.cast(candidate));
        }
        return null;
    }

    public <S extends XMPSchema> S getOrCreateSchema(Class<S> type) throws IOException {
        Object schema = this.getSchema(type);
        if (schema == null) {
            try {
                Constructor<S> constructor = type.getConstructor(XMPMetadata.class);
                schema = (XMPSchema)constructor.newInstance(new Object[]{this});
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
                throw new IOException("Failed to create create schema: " + type, exception);
            }
            this.basicAddSchema((XMPSchema)schema);
        }
        return schema;
    }

    public static class Builder {
        private Document document;
        private Map<String, Class<? extends XMPSchema>> schemaTypesByNamespaceUri = new HashMap<String, Class<? extends XMPSchema>>();

        public Builder withDocument(Document document) {
            this.document = document;
            return this;
        }

        public Builder withSchema(String namespace, Class<? extends XMPSchema> schemaType) {
            this.schemaTypesByNamespaceUri.put(namespace, schemaType);
            return this;
        }

        public Builder withPdfaSchemas() {
            return this.withSchema("http://www.aiim.org/pdfa/ns/id/", XMPSchemaPDFAId.class).withSchema("http://www.aiim.org/pdfa/ns/extension/", XMPSchemaPDFAExtension.class);
        }

        public GenericXMPMetadata build() throws IOException {
            return this.document == null ? new GenericXMPMetadata(this.schemaTypesByNamespaceUri) : new GenericXMPMetadata(this.schemaTypesByNamespaceUri, this.document);
        }
    }
}

