/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.security.algorithm.common.Algorithm;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.EncryptionAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.certificate.IX509CertificateFactory;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.method.pdf.signature.ISignatureContainerFactory;
import de.intarsys.security.signature.EncodedSignature;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.function.OnError;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;

public class SignatureFactoryX509RsaSha1
implements ISignatureContainerFactory {
    public static final String RSA = "RSA";
    public static final COSName CN_ADOBE_X509_RSA_SHA1 = COSName.constant((String)"adbe.x509.rsa_sha1");

    @Override
    public ISignatureContainer createSignatureContainer(PDSignature pdSignature) throws IOException, GeneralSecurityException {
        byte[] contentBytes = pdSignature.getContentBytes();
        if (contentBytes.length == 0) {
            return null;
        }
        byte[] pkcs1Bytes = ASN1Tools.getASN1OctetStringOctets((byte[])contentBytes);
        List<IX509PublicKeyCertificate> certs = this.getCertificates(pdSignature);
        AlgorithmSpec digestAlgorithmSpec = new AlgorithmSpec((Algorithm)DigestAlgorithm.ALG_SHA1);
        String oid = SignatureAlgorithm.createOID((EncryptionAlgorithm)EncryptionAlgorithm.ALG_RSA, (DigestAlgorithm)DigestAlgorithm.ALG_SHA1, (String)"PKCS1Type1");
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.lookupAlgorithmCanonical((String)oid);
        AlgorithmSpec signatureAlgorithmSpec = new AlgorithmSpec((Algorithm)signatureAlgorithm);
        return new EncodedSignature(pkcs1Bytes, signatureAlgorithmSpec, digestAlgorithmSpec, certs);
    }

    protected List<IX509PublicKeyCertificate> getCertificates(PDSignature pdSignature) throws CertificateException {
        List certList = pdSignature.getCert();
        if (certList == null || certList.isEmpty()) {
            return Collections.emptyList();
        }
        return certList.stream().map(OnError.rethrow(arg_0 -> ((IX509CertificateFactory)X509CertificateFactory.get()).createPublicKeyCertificate(arg_0))).toList();
    }

    @Override
    public COSName getEncoding() {
        return CN_ADOBE_X509_RSA_SHA1;
    }

    @Override
    public COSName getName() {
        return null;
    }
}

