/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class PDSignatureByteRange
extends InputStream {
    private final IRandomAccess randomAccess;
    private List ranges;
    private COSArray cosObject;

    public static List toRangeList(COSArray byteRange) {
        int size = byteRange.size() / 2;
        ArrayList<Range> ranges = new ArrayList<Range>(size);
        for (int c = 0; c < size; ++c) {
            long offset = byteRange.get(c * 2).asInteger().longValue();
            long length = byteRange.get(c * 2 + 1).asInteger().longValue();
            ranges.add(new Range(offset, length));
        }
        return ranges;
    }

    public PDSignatureByteRange(COSArray byteRange, IRandomAccess randomAccess) {
        this.randomAccess = randomAccess;
        this.cosObject = byteRange;
        this.ranges = PDSignatureByteRange.toRangeList(byteRange);
    }

    public void add(Range range) {
        Range before = this.getRange(range.getStart());
        if (before == null) {
            this.ranges.add(range);
        } else {
            int i = this.ranges.indexOf(before);
            this.ranges.add(i + 1, range);
        }
    }

    @Override
    public int available() throws IOException {
        long rest = this.getTotalLength() - this.randomAccess.getOffset();
        return (int)Math.min(rest, Integer.MAX_VALUE);
    }

    public COSArray cosGetObject() {
        return this.cosObject;
    }

    private Range getRange(long offset) {
        for (Range range : this.ranges) {
            if (offset >= range.getEnd()) continue;
            return range;
        }
        return null;
    }

    public long getTotalLength() {
        if (this.ranges == null || this.ranges.isEmpty()) {
            return 0L;
        }
        Range last = (Range)this.ranges.get(this.ranges.size() - 1);
        return last.getEnd();
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        this.read(buffer);
        return buffer[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long offset = this.randomAccess.getOffset();
        Range range = this.getRange(offset);
        if (range != null) {
            return range.read(this.randomAccess, b, off, len);
        }
        return -1;
    }

    public static class Range {
        private long start;
        private long length;

        public Range(long start, long length) {
            this.start = start;
            this.length = length;
        }

        public long getEnd() {
            return this.start + this.length;
        }

        public long getLength() {
            return this.length;
        }

        public long getStart() {
            return this.start;
        }

        public int read(IRandomAccess randomAccess, byte[] buffer, int off, int len) throws IOException {
            long available;
            long offset = (int)randomAccess.getOffset();
            if (offset < this.getStart()) {
                randomAccess.seek(this.getStart());
                offset = this.getStart();
            }
            int readLength = (available = this.getEnd() - offset) < (long)len ? (int)available : len;
            return randomAccess.read(buffer, off, readLength);
        }
    }
}

